/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.kerby.config;

import io.hops.hadoop.shaded.org.apache.kerby.config.ConfigImpl;
import io.hops.hadoop.shaded.org.apache.kerby.config.ConfigLoader;
import io.hops.hadoop.shaded.org.apache.kerby.config.Resource;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;

public class IniConfigLoader
extends ConfigLoader {
    private static final String COMMENT_SYMBOL = "#";
    private ConfigImpl rootConfig;
    private ConfigImpl currentConfig;

    @Override
    protected void loadConfig(ConfigImpl config, Resource resource) throws IOException {
        String line;
        this.rootConfig = config;
        this.currentConfig = config;
        InputStream is = (InputStream)resource.getResource();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
        while ((line = reader.readLine()) != null) {
            this.parseLine(line);
        }
        reader.close();
    }

    private void parseLine(String line) {
        if (line == null) {
            return;
        }
        if ((line = line.trim()).startsWith(COMMENT_SYMBOL)) {
            return;
        }
        if (line.matches("\\[.*\\]")) {
            String subConfigName = line.replaceFirst("\\[(.*)\\]", "$1");
            ConfigImpl subConfig = new ConfigImpl(subConfigName);
            this.rootConfig.set(subConfigName, subConfig);
            this.currentConfig = subConfig;
        } else if (line.matches(".*=.*")) {
            int i = line.indexOf(61);
            String name = line.substring(0, i).trim();
            String value = line.substring(i + 1).trim();
            this.currentConfig.set(name, value);
        }
    }
}

