/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.kerby.config;

import io.hops.hadoop.shaded.org.apache.kerby.config.ConfigImpl;
import io.hops.hadoop.shaded.org.apache.kerby.config.ConfigLoader;
import io.hops.hadoop.shaded.org.apache.kerby.config.Resource;
import java.util.Map;

public class MapConfigLoader
extends ConfigLoader {
    @Override
    protected void loadConfig(ConfigImpl config, Resource resource) {
        Map mapConfig = (Map)resource.getResource();
        for (Map.Entry entry : mapConfig.entrySet()) {
            if (entry.getValue() instanceof String) {
                config.set((String)entry.getKey(), (String)entry.getValue());
                continue;
            }
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                ConfigImpl subConfig = new ConfigImpl(key);
                this.loadSubmap(subConfig, (Map)value);
                config.add(subConfig);
                continue;
            }
            throw new RuntimeException("Unable to resolve config:" + key);
        }
    }

    private void loadSubmap(ConfigImpl config, Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof String) {
                config.set(key, (String)value);
            }
            if (!(value instanceof Map)) continue;
            ConfigImpl subConfig = new ConfigImpl(key);
            this.loadSubmap(subConfig, (Map)value);
            config.add(subConfig);
        }
    }
}

