/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.kerby.config;

import io.hops.hadoop.shaded.org.apache.kerby.config.Config;
import io.hops.hadoop.shaded.org.apache.kerby.config.ConfigImpl;
import io.hops.hadoop.shaded.org.apache.kerby.config.ConfigLoader;
import io.hops.hadoop.shaded.org.apache.kerby.config.ConfigObject;
import io.hops.hadoop.shaded.org.apache.kerby.config.Resource;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XmlConfigLoader
extends ConfigLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(Config.class);

    @Override
    protected void loadConfig(ConfigImpl config, Resource resource) throws Exception {
        Element doc = this.loadResourceDocument(resource);
        this.loadConfig(config, doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element loadResourceDocument(Resource resource) throws Exception {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        docBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        docBuilderFactory.setIgnoringComments(true);
        docBuilderFactory.setNamespaceAware(true);
        try {
            docBuilderFactory.setXIncludeAware(true);
        }
        catch (UnsupportedOperationException e) {
            LOGGER.error("Failed to set setXIncludeAware(true) for parser", (Throwable)e);
        }
        DocumentBuilder builder = docBuilderFactory.newDocumentBuilder();
        Document doc = null;
        try (InputStream is = (InputStream)resource.getResource();){
            doc = builder.parse(is);
        }
        Element root = doc.getDocumentElement();
        this.validateConfig(root);
        return root;
    }

    private boolean validateConfig(Element root) {
        boolean valid = false;
        if ("config".equals(root.getTagName())) {
            valid = true;
        } else {
            LOGGER.error("bad conf element: top-level element not <configuration>");
        }
        return valid;
    }

    private void loadConfig(ConfigImpl config, Element element) {
        NodeList props = element.getChildNodes();
        for (int i = 0; i < props.getLength(); ++i) {
            Element prop;
            String name;
            Node subNode = props.item(i);
            if (!(subNode instanceof Element) || (name = XmlConfigLoader.getElementName(prop = (Element)subNode)) == null) continue;
            ConfigObject value = null;
            String tagName = prop.getTagName();
            if ("property".equals(tagName) && prop.hasChildNodes()) {
                value = XmlConfigLoader.loadProperty(prop);
            } else if ("config".equals(tagName) && prop.hasChildNodes()) {
                ConfigImpl cfg = new ConfigImpl(name);
                this.loadConfig(cfg, prop);
                value = new ConfigObject(cfg);
            }
            config.set(name, value);
        }
    }

    private static ConfigObject loadProperty(Element ele) {
        if (ele.getFirstChild() instanceof Text) {
            String value = ((Text)ele.getFirstChild()).getData();
            return new ConfigObject(value);
        }
        NodeList nodes = ele.getChildNodes();
        ArrayList<String> values = new ArrayList<String>(nodes.getLength());
        for (int i = 0; i < nodes.getLength(); ++i) {
            String value = null;
            Node valueNode = nodes.item(i);
            if (!(valueNode instanceof Element)) continue;
            Element valueEle = (Element)valueNode;
            if ("value".equals(valueEle.getTagName()) && valueEle.hasChildNodes()) {
                value = ((Text)valueEle.getFirstChild()).getData();
            }
            if (value == null) continue;
            values.add(value);
        }
        return new ConfigObject(values);
    }

    private static String getElementName(Element ele) {
        NamedNodeMap nnm = ele.getAttributes();
        for (int i = 0; i < nnm.getLength(); ++i) {
            Attr attr;
            Node node = nnm.item(i);
            if (!(node instanceof Attr) || !"name".equals((attr = (Attr)node).getName())) continue;
            return attr.getValue();
        }
        return null;
    }
}

