/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb;

import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.provider.TokenProvider;
import java.util.Collections;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenProviderRegistry {
    static final Logger LOG = LoggerFactory.getLogger(TokenProviderRegistry.class);
    private static Map<String, Class> allProvider = new ConcurrentHashMap<String, Class>();

    public static Set<String> registeredProviders() {
        return Collections.unmodifiableSet(allProvider.keySet());
    }

    public static boolean registeredProvider(String name) {
        return allProvider.containsKey(name);
    }

    public static TokenProvider createProvider(String name) {
        if (!TokenProviderRegistry.registeredProvider(name)) {
            LOG.error("Unregistered token provider " + name);
            throw new RuntimeException("Unregistered token provider " + name);
        }
        try {
            return (TokenProvider)allProvider.get(name).newInstance();
        }
        catch (Exception e) {
            LOG.error("Create {} token provider failed", (Object)name, (Object)e);
            throw new RuntimeException("Create " + name + "token provider failed" + e);
        }
    }

    static {
        ServiceLoader<TokenProvider> providers = ServiceLoader.load(TokenProvider.class);
        for (TokenProvider provider : providers) {
            allProvider.put(provider.getTokenType(), provider.getClass());
        }
    }
}

