/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.admin.kadmin.remote;

import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.KrbException;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.admin.kadmin.remote.AdminConfig;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.admin.kadmin.remote.AdminSetting;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.transport.TransportPair;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Map;

public final class AdminUtil {
    private static final String KRB5_FILE_NAME = "krb5.conf";
    private static final String KRB5_ENV_NAME = "KRB5_CONFIG";

    private AdminUtil() {
    }

    public static AdminConfig getConfig(File confDir) throws KrbException {
        File confFile = new File(confDir, KRB5_FILE_NAME);
        if (!confFile.exists()) {
            throw new KrbException("krb5.conf not found");
        }
        AdminConfig adminConfig = new AdminConfig();
        try {
            adminConfig.addKrb5Config(confFile);
            return adminConfig;
        }
        catch (IOException e) {
            throw new KrbException("Failed to load krb config " + confFile.getAbsolutePath());
        }
    }

    public static AdminConfig getDefaultConfig() throws KrbException {
        String tmpEnv;
        File confFile = null;
        try {
            Map<String, String> mapEnv = System.getenv();
            tmpEnv = mapEnv.get(KRB5_ENV_NAME);
        }
        catch (SecurityException e) {
            tmpEnv = null;
        }
        if (tmpEnv != null) {
            confFile = new File(tmpEnv);
            if (!confFile.exists()) {
                throw new KrbException("krb5 conf not found. Invalid env KRB5_CONFIG");
            }
        } else {
            File confDir = new File("/etc/");
            if (confDir.exists()) {
                confFile = new File(confDir, KRB5_FILE_NAME);
            }
        }
        AdminConfig adminConfig = new AdminConfig();
        if (confFile != null && confFile.exists()) {
            try {
                adminConfig.addKrb5Config(confFile);
            }
            catch (IOException e) {
                throw new KrbException("Failed to load krb config " + confFile.getAbsolutePath());
            }
        }
        return adminConfig;
    }

    public static TransportPair getTransportPair(AdminSetting setting) throws KrbException {
        int udpPort;
        TransportPair result = new TransportPair();
        int tcpPort = setting.checkGetKdcTcpPort();
        if (tcpPort > 0) {
            result.tcpAddress = new InetSocketAddress(setting.getKdcHost(), tcpPort);
        }
        if ((udpPort = setting.checkGetKdcUdpPort()) > 0) {
            result.udpAddress = new InetSocketAddress(setting.getKdcHost(), udpPort);
        }
        return result;
    }
}

