/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.client;

import io.hops.hadoop.shaded.org.apache.kerby.KOptions;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.KrbException;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.ccache.Credential;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.ccache.CredentialCache;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.ClientUtil;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.KrbConfig;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.KrbKdcOption;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.KrbOption;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.KrbSetting;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.impl.DefaultInternalKrbClient;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.impl.InternalKrbClient;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.kdc.EncAsRepPart;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.ticket.SgtTicket;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.ticket.TgtTicket;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KrbClientBase {
    private final KrbConfig krbConfig;
    private final KOptions commonOptions;
    private final KrbSetting krbSetting;
    private InternalKrbClient innerClient;
    private static final Logger LOG = LoggerFactory.getLogger(KrbClientBase.class);

    public KrbClientBase() throws KrbException {
        this.krbConfig = ClientUtil.getDefaultConfig();
        this.commonOptions = new KOptions();
        this.krbSetting = new KrbSetting(this.commonOptions, this.krbConfig);
    }

    public KrbClientBase(KrbConfig krbConfig) {
        this.krbConfig = krbConfig;
        this.commonOptions = new KOptions();
        this.krbSetting = new KrbSetting(this.commonOptions, krbConfig);
    }

    public KrbClientBase(File confDir) throws KrbException {
        this.commonOptions = new KOptions();
        this.krbConfig = ClientUtil.getConfig(confDir);
        this.krbSetting = new KrbSetting(this.commonOptions, this.krbConfig);
    }

    public KrbClientBase(KrbClientBase krbClient) {
        this.commonOptions = krbClient.commonOptions;
        this.krbConfig = krbClient.krbConfig;
        this.krbSetting = krbClient.krbSetting;
        this.innerClient = krbClient.innerClient;
    }

    public void setKdcRealm(String realm) {
        this.commonOptions.add(KrbOption.KDC_REALM, realm);
    }

    public void setKdcHost(String kdcHost) {
        this.commonOptions.add(KrbOption.KDC_HOST, kdcHost);
    }

    public void setKdcTcpPort(int kdcTcpPort) {
        if (kdcTcpPort < 1) {
            throw new IllegalArgumentException("Invalid port");
        }
        this.commonOptions.add(KrbOption.KDC_TCP_PORT, kdcTcpPort);
        this.setAllowTcp(true);
    }

    public void setAllowUdp(boolean allowUdp) {
        this.commonOptions.add(KrbOption.ALLOW_UDP, allowUdp);
    }

    public void setAllowTcp(boolean allowTcp) {
        this.commonOptions.add(KrbOption.ALLOW_TCP, allowTcp);
    }

    public void setKdcUdpPort(int kdcUdpPort) {
        if (kdcUdpPort < 1) {
            throw new IllegalArgumentException("Invalid port");
        }
        this.commonOptions.add(KrbOption.KDC_UDP_PORT, kdcUdpPort);
        this.setAllowUdp(true);
    }

    public void setTimeout(int timeout) {
        this.commonOptions.add(KrbOption.CONN_TIMEOUT, timeout);
    }

    public void init() throws KrbException {
        this.innerClient = new DefaultInternalKrbClient(this.krbSetting);
        this.innerClient.init();
    }

    public KrbSetting getSetting() {
        return this.krbSetting;
    }

    public KrbConfig getKrbConfig() {
        return this.krbConfig;
    }

    public TgtTicket requestTgt(KOptions requestOptions) throws KrbException {
        if (requestOptions == null) {
            throw new IllegalArgumentException("Null requestOptions specified");
        }
        return this.innerClient.requestTgt(requestOptions);
    }

    public SgtTicket requestSgt(TgtTicket tgt, String serverPrincipal) throws KrbException {
        KOptions requestOptions = new KOptions();
        requestOptions.add(KrbOption.USE_TGT, tgt);
        requestOptions.add(KrbOption.SERVER_PRINCIPAL, serverPrincipal);
        return this.innerClient.requestSgt(requestOptions);
    }

    public SgtTicket requestSgt(KOptions requestOptions) throws KrbException {
        return this.innerClient.requestSgt(requestOptions);
    }

    public SgtTicket requestSgt(File ccFile, String servicePrincipal) throws KrbException {
        Credential credential = this.getCredentialFromFile(ccFile);
        TgtTicket tgt = this.getTgtTicketFromCredential(credential);
        KOptions requestOptions = new KOptions();
        if (servicePrincipal == null) {
            requestOptions.add(KrbKdcOption.RENEW);
            servicePrincipal = credential.getServicePrincipal().getName();
        }
        requestOptions.add(KrbOption.USE_TGT, tgt);
        requestOptions.add(KrbOption.SERVER_PRINCIPAL, servicePrincipal);
        SgtTicket sgtTicket = this.innerClient.requestSgt(requestOptions);
        sgtTicket.setClientPrincipal(tgt.getClientPrincipal());
        return sgtTicket;
    }

    public void storeTicket(TgtTicket tgtTicket, File ccacheFile) throws KrbException {
        LOG.info("Storing the tgt to the credential cache file.");
        if (!ccacheFile.exists()) {
            this.createCacheFile(ccacheFile);
        }
        if (ccacheFile.exists() && ccacheFile.canWrite()) {
            CredentialCache cCache = new CredentialCache(tgtTicket);
            try {
                cCache.store(ccacheFile);
            }
            catch (IOException e) {
                throw new KrbException("Failed to store tgt", (Throwable)e);
            }
        } else {
            throw new IllegalArgumentException("Invalid ccache file, not exist or writable: " + ccacheFile.getAbsolutePath());
        }
    }

    public void storeTicket(SgtTicket sgtTicket, File ccacheFile) throws KrbException {
        boolean createCache;
        LOG.info("Storing the sgt to the credential cache file.");
        boolean bl = createCache = !ccacheFile.exists() || ccacheFile.length() == 0L;
        if (createCache) {
            this.createCacheFile(ccacheFile);
        }
        if (ccacheFile.exists() && ccacheFile.canWrite()) {
            try {
                CredentialCache cCache;
                if (!createCache) {
                    cCache = new CredentialCache();
                    cCache.load(ccacheFile);
                    cCache.addCredential(new Credential(sgtTicket, sgtTicket.getClientPrincipal()));
                } else {
                    cCache = new CredentialCache(sgtTicket);
                }
                cCache.store(ccacheFile);
            }
            catch (IOException e) {
                throw new KrbException("Failed to store sgt", (Throwable)e);
            }
        } else {
            throw new IllegalArgumentException("Invalid ccache file, not exist or writable: " + ccacheFile.getAbsolutePath());
        }
    }

    public void renewTicket(SgtTicket sgtTicket, File ccacheFile) throws KrbException {
        LOG.info("Renewing the ticket to the credential cache file.");
        if (!ccacheFile.exists()) {
            this.createCacheFile(ccacheFile);
        }
        if (ccacheFile.exists() && ccacheFile.canWrite()) {
            CredentialCache cCache = new CredentialCache(sgtTicket);
            try {
                cCache.store(ccacheFile);
            }
            catch (IOException e) {
                throw new KrbException("Failed to renew ticket", (Throwable)e);
            }
        } else {
            throw new IllegalArgumentException("Invalid ccache file, not exist or writable: " + ccacheFile.getAbsolutePath());
        }
    }

    private void createCacheFile(File ccacheFile) throws KrbException {
        try {
            if (!ccacheFile.createNewFile()) {
                throw new KrbException("Failed to create ccache file " + ccacheFile.getAbsolutePath());
            }
            ccacheFile.setReadable(true, true);
            if (!ccacheFile.setWritable(true, true)) {
                throw new KrbException("Cache file is not readable.");
            }
        }
        catch (IOException e) {
            throw new KrbException("Failed to create ccache file " + ccacheFile.getAbsolutePath(), (Throwable)e);
        }
    }

    public TgtTicket getTgtTicketFromCredential(Credential cc) {
        EncAsRepPart encAsRepPart = new EncAsRepPart();
        encAsRepPart.setAuthTime(cc.getAuthTime());
        encAsRepPart.setCaddr(cc.getClientAddresses());
        encAsRepPart.setEndTime(cc.getEndTime());
        encAsRepPart.setFlags(cc.getTicketFlags());
        encAsRepPart.setKey(cc.getKey());
        encAsRepPart.setRenewTill(cc.getRenewTill());
        encAsRepPart.setSname(cc.getServerName());
        encAsRepPart.setSrealm(cc.getServerName().getRealm());
        encAsRepPart.setStartTime(cc.getStartTime());
        TgtTicket tgtTicket = new TgtTicket(cc.getTicket(), encAsRepPart, cc.getClientName());
        return tgtTicket;
    }

    public Credential getCredentialFromFile(File ccFile) throws KrbException {
        CredentialCache cc;
        try {
            cc = this.resolveCredCache(ccFile);
        }
        catch (IOException e) {
            throw new KrbException("Failed to load armor cache file");
        }
        return cc.getCredentials().iterator().next();
    }

    public CredentialCache resolveCredCache(File ccacheFile) throws IOException {
        CredentialCache cc = new CredentialCache();
        cc.load(ccacheFile);
        return cc;
    }
}

