/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.impl;

import io.hops.hadoop.shaded.org.apache.kerby.KOption;
import io.hops.hadoop.shaded.org.apache.kerby.KOptions;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.KrbException;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.KrbConfig;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.KrbContext;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.KrbOption;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.KrbSetting;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.PkinitOption;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.TokenOption;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.impl.InternalKrbClient;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.request.AsRequest;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.request.AsRequestWithCert;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.request.AsRequestWithKeytab;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.request.AsRequestWithPasswd;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.request.AsRequestWithToken;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.request.TgsRequest;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.request.TgsRequestWithTgt;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.request.TgsRequestWithToken;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.common.KrbUtil;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.NameType;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.PrincipalName;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.ticket.SgtTicket;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.ticket.TgtTicket;
import java.util.LinkedList;

public abstract class AbstractInternalKrbClient
implements InternalKrbClient {
    private KrbContext context;
    private final KrbSetting krbSetting;

    public AbstractInternalKrbClient(KrbSetting krbSetting) {
        this.krbSetting = krbSetting;
    }

    protected KrbContext getContext() {
        return this.context;
    }

    @Override
    public KrbSetting getSetting() {
        return this.krbSetting;
    }

    @Override
    public void init() throws KrbException {
        this.context = new KrbContext();
        this.context.init(this.krbSetting);
    }

    @Override
    public TgtTicket requestTgt(KOptions requestOptions) throws KrbException {
        AsRequest asRequest = null;
        PrincipalName clientPrincipalName = null;
        if (requestOptions.contains(KrbOption.USE_PASSWD)) {
            asRequest = new AsRequestWithPasswd(this.context);
        } else if (requestOptions.contains(KrbOption.USE_KEYTAB)) {
            asRequest = new AsRequestWithKeytab(this.context);
        } else if (requestOptions.contains(PkinitOption.USE_ANONYMOUS)) {
            asRequest = new AsRequestWithCert(this.context);
        } else if (requestOptions.contains(PkinitOption.USE_PKINIT)) {
            asRequest = new AsRequestWithCert(this.context);
        } else if (requestOptions.contains(TokenOption.USE_TOKEN)) {
            asRequest = new AsRequestWithToken(this.context);
        } else if (requestOptions.contains(TokenOption.USER_ID_TOKEN)) {
            asRequest = new AsRequestWithToken(this.context);
        }
        if (asRequest == null) {
            throw new IllegalArgumentException("No valid krb client request option found");
        }
        if (requestOptions.contains(KrbOption.CLIENT_PRINCIPAL)) {
            String clientPrincipalString = requestOptions.getStringOption(KrbOption.CLIENT_PRINCIPAL);
            clientPrincipalString = this.fixPrincipal(clientPrincipalString);
            clientPrincipalName = new PrincipalName(clientPrincipalString);
            if (requestOptions.contains(PkinitOption.USE_ANONYMOUS)) {
                clientPrincipalName.setNameType(NameType.NT_WELLKNOWN);
            }
            asRequest.setClientPrincipal(clientPrincipalName);
        }
        if (requestOptions.contains(KrbOption.SERVER_PRINCIPAL)) {
            String serverPrincipalString = requestOptions.getStringOption(KrbOption.SERVER_PRINCIPAL);
            serverPrincipalString = this.fixPrincipal(serverPrincipalString);
            PrincipalName serverPrincipalName = new PrincipalName(serverPrincipalString, NameType.NT_PRINCIPAL);
            asRequest.setServerPrincipal(serverPrincipalName);
        } else if (clientPrincipalName != null) {
            String realm = clientPrincipalName.getRealm();
            PrincipalName serverPrincipalName = KrbUtil.makeTgsPrincipal(realm);
            asRequest.setServerPrincipal(serverPrincipalName);
        }
        asRequest.setRequestOptions(requestOptions);
        return this.doRequestTgt(asRequest);
    }

    @Override
    public SgtTicket requestSgt(KOptions requestOptions) throws KrbException {
        TgsRequest tgsRequest = null;
        TgtTicket tgtTicket = null;
        if (requestOptions.contains(TokenOption.USER_AC_TOKEN)) {
            tgsRequest = new TgsRequestWithToken(this.context);
        } else if (requestOptions.contains(KrbOption.USE_TGT)) {
            KOption kOpt = requestOptions.getOption(KrbOption.USE_TGT);
            tgtTicket = (TgtTicket)kOpt.getOptionInfo().getValue();
            tgsRequest = new TgsRequestWithTgt(this.context, tgtTicket);
        }
        if (tgsRequest == null) {
            throw new IllegalArgumentException("No valid krb client request option found");
        }
        String serverPrincipalString = this.fixPrincipal(requestOptions.getStringOption(KrbOption.SERVER_PRINCIPAL));
        PrincipalName serverPrincipalName = new PrincipalName(serverPrincipalString);
        PrincipalName clientPrincipalName = null;
        if (tgtTicket != null) {
            String sourceRealm = tgtTicket.getRealm();
            String destRealm = serverPrincipalName.getRealm();
            clientPrincipalName = tgtTicket.getClientPrincipal();
            if (!sourceRealm.equals(destRealm)) {
                KrbConfig krbConfig = this.krbSetting.getKrbConfig();
                LinkedList<String> capath = krbConfig.getCapath(sourceRealm, destRealm);
                for (int i = 0; i < capath.size() - 1; ++i) {
                    PrincipalName tgsPrincipalName = KrbUtil.makeTgsPrincipal(capath.get(i), capath.get(i + 1));
                    tgsRequest.setServerPrincipal(tgsPrincipalName);
                    tgsRequest.setRequestOptions(requestOptions);
                    SgtTicket sgtTicket = this.doRequestSgt(tgsRequest);
                    sgtTicket.setClientPrincipal(clientPrincipalName);
                    tgsRequest = new TgsRequestWithTgt(this.context, sgtTicket);
                }
            }
        } else {
            String clientPrincipalString = (String)requestOptions.getOptionValue(KrbOption.CLIENT_PRINCIPAL);
            if (clientPrincipalString != null) {
                clientPrincipalName = new PrincipalName(clientPrincipalString);
            }
        }
        tgsRequest.setServerPrincipal(serverPrincipalName);
        tgsRequest.setRequestOptions(requestOptions);
        SgtTicket sgtTicket = this.doRequestSgt(tgsRequest);
        if (clientPrincipalName != null) {
            sgtTicket.setClientPrincipal(clientPrincipalName);
        }
        return sgtTicket;
    }

    protected abstract TgtTicket doRequestTgt(AsRequest var1) throws KrbException;

    protected abstract SgtTicket doRequestSgt(TgsRequest var1) throws KrbException;

    protected String fixPrincipal(String principal) {
        if (!principal.contains("@")) {
            principal = principal + "@" + this.krbSetting.getKdcRealm();
        }
        return principal;
    }
}

