/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.request;

import io.hops.hadoop.shaded.org.apache.kerby.KOptions;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.KrbCodec;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.KrbException;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.ccache.Credential;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.ccache.CredentialCache;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.KrbOption;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.preauth.KrbFastRequestState;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.request.KdcRequest;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.common.CheckSumUtil;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.common.EncryptionUtil;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.crypto.EncryptionHandler;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.crypto.fast.FastUtil;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.KerberosTime;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.ap.ApOptions;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.ap.ApReq;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.ap.Authenticator;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.CheckSum;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.CheckSumType;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.EncryptedData;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.EncryptionKey;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.EncryptionType;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.KeyUsage;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.fast.ArmorType;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.fast.KrbFastArmor;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.fast.KrbFastArmoredReq;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.fast.KrbFastReq;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.fast.PaFxFastRequest;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.kdc.AsReq;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.kdc.KdcReq;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.kdc.KdcReqBody;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.pa.PaDataEntry;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.pa.PaDataType;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.ticket.TgtTicket;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.ticket.Ticket;
import java.io.File;
import java.io.IOException;

public class ArmoredRequest {
    private Credential credential;
    private EncryptionKey subKey;
    private EncryptionKey armorCacheKey;
    private KdcRequest kdcRequest;

    public ArmoredRequest(KdcRequest kdcRequest) {
        this.kdcRequest = kdcRequest;
    }

    public void process() throws KrbException {
        KdcReq kdcReq = this.kdcRequest.getKdcReq();
        KrbFastRequestState state = this.kdcRequest.getFastRequestState();
        this.fastAsArmor(state, this.kdcRequest.getArmorKey(), this.subKey, this.credential, kdcReq);
        this.kdcRequest.setFastRequestState(state);
        this.kdcRequest.setOuterRequestBody(KrbCodec.encode(state.getFastOuterRequest().getReqBody()));
        kdcReq.getPaData().addElement(this.makeFastEntry(state, kdcReq, this.kdcRequest.getOuterRequestBody()));
    }

    protected void preauth() throws KrbException {
        KOptions preauthOptions = this.getPreauthOptions();
        this.getCredential(preauthOptions);
        this.armorCacheKey = this.getArmorCacheKey(this.credential);
        this.subKey = this.getSubKey(this.armorCacheKey.getKeyType());
        EncryptionKey armorKey = this.makeArmorKey(this.subKey, this.armorCacheKey);
        this.kdcRequest.getFastRequestState().setArmorKey(armorKey);
    }

    private void getCredential(KOptions kOptions) throws KrbException {
        if (kOptions.contains(KrbOption.ARMOR_CACHE)) {
            String ccache = kOptions.getStringOption(KrbOption.ARMOR_CACHE);
            this.credential = this.getCredentialFromFile(ccache);
        } else if (kOptions.contains(KrbOption.TGT)) {
            TgtTicket tgt = (TgtTicket)kOptions.getOptionValue(KrbOption.TGT);
            this.credential = new Credential(tgt);
        }
    }

    public KOptions getPreauthOptions() {
        KOptions results = new KOptions();
        KOptions krbOptions = this.kdcRequest.getRequestOptions();
        if (krbOptions.contains(KrbOption.ARMOR_CACHE)) {
            results.add(krbOptions.getOption(KrbOption.ARMOR_CACHE));
        } else if (krbOptions.contains(KrbOption.TGT)) {
            results.add(krbOptions.getOption(KrbOption.TGT));
        }
        return results;
    }

    public EncryptionKey getClientKey() throws KrbException {
        return this.kdcRequest.getFastRequestState().getArmorKey();
    }

    public EncryptionKey getArmorCacheKey() {
        return this.armorCacheKey;
    }

    private Credential getCredentialFromFile(String ccache) throws KrbException {
        File ccacheFile = new File(ccache);
        CredentialCache cc = null;
        try {
            cc = ArmoredRequest.resolveCredCache(ccacheFile);
        }
        catch (IOException e) {
            throw new KrbException("Failed to load armor cache file");
        }
        return cc.getCredentials().iterator().next();
    }

    private static CredentialCache resolveCredCache(File ccacheFile) throws IOException {
        CredentialCache cc = new CredentialCache();
        cc.load(ccacheFile);
        return cc;
    }

    private void fastAsArmor(KrbFastRequestState state, EncryptionKey armorKey, EncryptionKey subKey, Credential credential, KdcReq kdcReq) throws KrbException {
        state.setArmorKey(armorKey);
        state.setFastArmor(this.fastArmorApRequest(subKey, credential));
        AsReq fastOuterRequest = new AsReq();
        fastOuterRequest.setReqBody(kdcReq.getReqBody());
        fastOuterRequest.setPaData(null);
        state.setFastOuterRequest(fastOuterRequest);
    }

    private PaDataEntry makeFastEntry(KrbFastRequestState state, KdcReq kdcReq, byte[] outerRequestBody) throws KrbException {
        KrbFastReq fastReq = new KrbFastReq();
        fastReq.setKdcReqBody(kdcReq.getReqBody());
        fastReq.setFastOptions(state.getFastOptions());
        PaFxFastRequest paFxFastRequest = new PaFxFastRequest();
        KrbFastArmoredReq armoredReq = new KrbFastArmoredReq();
        armoredReq.setArmor(state.getFastArmor());
        CheckSum reqCheckSum = CheckSumUtil.makeCheckSumWithKey(CheckSumType.NONE, outerRequestBody, state.getArmorKey(), KeyUsage.FAST_REQ_CHKSUM);
        armoredReq.setReqChecksum(reqCheckSum);
        armoredReq.setEncryptedFastReq(EncryptionUtil.seal(fastReq, state.getArmorKey(), KeyUsage.FAST_ENC));
        paFxFastRequest.setFastArmoredReq(armoredReq);
        PaDataEntry paDataEntry = new PaDataEntry();
        paDataEntry.setPaDataType(PaDataType.FX_FAST);
        paDataEntry.setPaDataValue(KrbCodec.encode(paFxFastRequest));
        return paDataEntry;
    }

    private KrbFastArmor fastArmorApRequest(EncryptionKey subKey, Credential credential) throws KrbException {
        KrbFastArmor fastArmor = new KrbFastArmor();
        fastArmor.setArmorType(ArmorType.ARMOR_AP_REQUEST);
        ApReq apReq = this.makeApReq(subKey, credential);
        fastArmor.setArmorValue(KrbCodec.encode(apReq));
        return fastArmor;
    }

    private ApReq makeApReq(EncryptionKey subKey, Credential credential) throws KrbException {
        ApReq apReq = new ApReq();
        ApOptions apOptions = new ApOptions();
        apReq.setApOptions(apOptions);
        Ticket ticket = credential.getTicket();
        apReq.setTicket(ticket);
        Authenticator authenticator = this.makeAuthenticator(credential, subKey);
        apReq.setAuthenticator(authenticator);
        EncryptedData authnData = EncryptionUtil.seal(authenticator, credential.getKey(), KeyUsage.AP_REQ_AUTH);
        apReq.setEncryptedAuthenticator(authnData);
        return apReq;
    }

    private EncryptionKey makeArmorKey(EncryptionKey subKey, EncryptionKey armorCacheKey) throws KrbException {
        EncryptionKey armorKey = FastUtil.makeArmorKey(subKey, armorCacheKey);
        return armorKey;
    }

    private EncryptionKey getSubKey(EncryptionType type) throws KrbException {
        return EncryptionHandler.random2Key(type);
    }

    private EncryptionKey getArmorCacheKey(Credential credential) throws KrbException {
        EncryptionKey armorCacheKey = credential.getKey();
        return armorCacheKey;
    }

    protected Authenticator makeAuthenticator(Credential credential, EncryptionKey subKey) throws KrbException {
        Authenticator authenticator = new Authenticator();
        authenticator.setAuthenticatorVno(5);
        authenticator.setCname(credential.getClientName());
        authenticator.setCrealm(credential.getClientRealm());
        authenticator.setCtime(KerberosTime.now());
        authenticator.setCusec(0);
        authenticator.setSubKey(subKey);
        KdcReqBody reqBody = this.kdcRequest.getReqBody(null);
        CheckSum checksum = CheckSumUtil.seal(reqBody, null, subKey, KeyUsage.TGS_REQ_AUTH_CKSUM);
        authenticator.setCksum(checksum);
        return authenticator;
    }
}

