/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.request;

import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.KrbErrorCode;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.KrbException;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.ccache.CredentialCache;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.KrbContext;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.PkinitOption;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.TokenOption;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.request.KdcRequest;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.common.KrbUtil;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.EncryptionKey;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.HostAddress;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.HostAddresses;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.KeyUsage;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.PrincipalName;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.kdc.AsReq;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.kdc.EncAsRepPart;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.kdc.KdcRep;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.kdc.KdcReqBody;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.ticket.TgtTicket;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class AsRequest
extends KdcRequest {
    private PrincipalName clientPrincipal;
    private EncryptionKey clientKey;

    public AsRequest(KrbContext context) {
        super(context);
        this.setServerPrincipal(this.makeTgsPrincipal());
    }

    @Override
    public PrincipalName getClientPrincipal() {
        return this.clientPrincipal;
    }

    public void setClientPrincipal(PrincipalName clientPrincipal) {
        this.clientPrincipal = clientPrincipal;
    }

    public void setClientKey(EncryptionKey clientKey) {
        this.clientKey = clientKey;
    }

    @Override
    public EncryptionKey getClientKey() throws KrbException {
        return this.clientKey;
    }

    @Override
    public void process() throws KrbException {
        super.process();
        KdcReqBody body = this.getReqBody(null);
        AsReq asReq = new AsReq();
        asReq.setReqBody(body);
        asReq.setPaData(this.getPreauthContext().getOutputPaData());
        this.setKdcReq(asReq);
    }

    @Override
    public void processResponse(KdcRep kdcRep) throws KrbException {
        List requestHosts;
        this.setKdcRep(kdcRep);
        PrincipalName clientPrincipal = this.getKdcRep().getCname();
        String clientRealm = this.getKdcRep().getCrealm();
        clientPrincipal.setRealm(clientRealm);
        if (!(this.getRequestOptions().contains(PkinitOption.USE_ANONYMOUS) && KrbUtil.pricipalCompareIgnoreRealm(clientPrincipal, this.getClientPrincipal()) || this.getRequestOptions().contains(TokenOption.USER_ID_TOKEN) || clientPrincipal.equals(this.getClientPrincipal()))) {
            throw new KrbException(KrbErrorCode.KDC_ERR_CLIENT_NAME_MISMATCH);
        }
        byte[] decryptedData = this.decryptWithClientKey(this.getKdcRep().getEncryptedEncPart(), KeyUsage.AS_REP_ENCPART);
        if ((decryptedData[0] & 0x1F) == 26) {
            decryptedData[0] = (byte)(decryptedData[0] - 1);
        }
        EncAsRepPart encKdcRepPart = new EncAsRepPart();
        try {
            encKdcRepPart.decode(decryptedData);
        }
        catch (IOException e) {
            throw new KrbException("Failed to decode EncAsRepPart", (Throwable)e);
        }
        this.getKdcRep().setEncPart(encKdcRepPart);
        if (this.getChosenNonce() != encKdcRepPart.getNonce()) {
            throw new KrbException("Nonce didn't match");
        }
        PrincipalName returnedServerPrincipal = encKdcRepPart.getSname();
        returnedServerPrincipal.setRealm(encKdcRepPart.getSrealm());
        PrincipalName requestedServerPrincipal = this.getServerPrincipal();
        if (requestedServerPrincipal.getRealm() == null) {
            requestedServerPrincipal.setRealm(this.getContext().getKrbSetting().getKdcRealm());
        }
        if (!returnedServerPrincipal.equals(requestedServerPrincipal)) {
            throw new KrbException(KrbErrorCode.KDC_ERR_SERVER_NOMATCH);
        }
        HostAddresses hostAddresses = this.getHostAddresses();
        if (hostAddresses != null && !(requestHosts = hostAddresses.getElements()).isEmpty()) {
            List responseHosts = encKdcRepPart.getCaddr().getElements();
            for (HostAddress h2 : requestHosts) {
                if (responseHosts.contains(h2)) continue;
                throw new KrbException("Unexpected client host");
            }
        }
    }

    public TgtTicket getTicket() {
        TgtTicket tgtTicket = new TgtTicket(this.getKdcRep().getTicket(), (EncAsRepPart)this.getKdcRep().getEncPart(), this.getKdcRep().getCname());
        return tgtTicket;
    }

    private PrincipalName makeTgsPrincipal() {
        return KrbUtil.makeTgsPrincipal(this.getContext().getKrbSetting().getKdcRealm());
    }

    protected CredentialCache resolveCredCache(File ccacheFile) throws IOException {
        CredentialCache cc = new CredentialCache();
        cc.load(ccacheFile);
        return cc;
    }
}

