/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.request;

import io.hops.hadoop.shaded.org.apache.kerby.KOptions;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.KrbException;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.KrbContext;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.PkinitOption;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.preauth.PreauthContext;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.request.AsRequest;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.EncryptionKey;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.kdc.AsReq;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.kdc.KdcOption;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.kdc.KdcRep;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.kdc.KdcReqBody;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.pa.PaDataType;

public class AsRequestWithCert
extends AsRequest {
    public static final String ANONYMOUS_PRINCIPAL = "ANONYMOUS@WELLKNOWN:ANONYMOUS";

    public AsRequestWithCert(KrbContext context) {
        super(context);
        this.setAllowedPreauth(PaDataType.PK_AS_REQ);
    }

    @Override
    public void process() throws KrbException {
        KdcReqBody body = this.getReqBody(null);
        AsReq asReq = new AsReq();
        asReq.setReqBody(body);
        this.setKdcReq(asReq);
        this.preauth();
        asReq.setPaData(this.getPreauthContext().getOutputPaData());
        this.setKdcReq(asReq);
    }

    @Override
    public KOptions getPreauthOptions() {
        KOptions results = new KOptions();
        KOptions krbOptions = this.getRequestOptions();
        results.add(krbOptions.getOption(PkinitOption.X509_CERTIFICATE));
        results.add(krbOptions.getOption(PkinitOption.X509_ANCHORS));
        results.add(krbOptions.getOption(PkinitOption.X509_PRIVATE_KEY));
        results.add(krbOptions.getOption(PkinitOption.X509_IDENTITY));
        results.add(krbOptions.getOption(PkinitOption.USING_RSA));
        if (krbOptions.contains(PkinitOption.USE_ANONYMOUS)) {
            this.getKdcOptions().setFlag(KdcOption.REQUEST_ANONYMOUS);
        }
        return results;
    }

    @Override
    public void processResponse(KdcRep kdcRep) throws KrbException {
        PreauthContext preauthContext = this.getPreauthContext();
        preauthContext.setInputPaData(kdcRep.getPaData());
        this.preauth();
        super.processResponse(kdcRep);
    }

    @Override
    public EncryptionKey getClientKey() throws KrbException {
        return this.getAsKey();
    }
}

