/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.request;

import io.hops.hadoop.shaded.org.apache.kerby.KOption;
import io.hops.hadoop.shaded.org.apache.kerby.KOptions;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.KrbException;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.KrbContext;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.KrbKdcOption;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.KrbOption;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.KrbOptionGroup;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.preauth.KrbFastRequestState;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.preauth.PreauthContext;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.preauth.PreauthHandler;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.common.EncryptionUtil;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.crypto.EncryptionHandler;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.KerberosTime;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.EncryptedData;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.EncryptionKey;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.EncryptionType;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.HostAddress;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.HostAddresses;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.KeyUsage;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.PrincipalName;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.kdc.KdcOption;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.kdc.KdcOptions;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.kdc.KdcRep;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.kdc.KdcReq;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.kdc.KdcReqBody;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.pa.PaDataType;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class KdcRequest {
    protected Map<String, Object> credCache;
    private KrbContext context;
    private Object sessionData;
    private KOptions requestOptions;
    private PrincipalName serverPrincipal;
    private List<HostAddress> hostAddresses = new ArrayList<HostAddress>();
    private KdcOptions kdcOptions = new KdcOptions();
    private List<EncryptionType> encryptionTypes;
    private EncryptionType chosenEncryptionType;
    private int chosenNonce;
    private KdcReq kdcReq;
    private KdcReqBody reqBody;
    private KdcRep kdcRep;
    private PreauthContext preauthContext;
    private KrbFastRequestState fastRequestState;
    private EncryptionKey asKey;
    private byte[] outerRequestBody;
    private boolean isRetrying;

    public KdcRequest(KrbContext context) {
        this.context = context;
        this.isRetrying = false;
        this.credCache = new HashMap<String, Object>();
        this.preauthContext = context.getPreauthHandler().preparePreauthContext(this);
        this.fastRequestState = new KrbFastRequestState();
    }

    public KrbFastRequestState getFastRequestState() {
        return this.fastRequestState;
    }

    public void setFastRequestState(KrbFastRequestState state) {
        this.fastRequestState = state;
    }

    public byte[] getOuterRequestBody() {
        return (byte[])this.outerRequestBody.clone();
    }

    public void setOuterRequestBody(byte[] outerRequestBody) {
        this.outerRequestBody = (byte[])outerRequestBody.clone();
    }

    public Object getSessionData() {
        return this.sessionData;
    }

    public void setSessionData(Object sessionData) {
        this.sessionData = sessionData;
    }

    public KOptions getRequestOptions() {
        return this.requestOptions;
    }

    public void setRequestOptions(KOptions options) {
        this.requestOptions = options;
    }

    public boolean isRetrying() {
        return this.isRetrying;
    }

    public EncryptionKey getAsKey() throws KrbException {
        return this.asKey;
    }

    public void setAsKey(EncryptionKey asKey) {
        this.asKey = asKey;
    }

    public void setAllowedPreauth(PaDataType paType) {
        this.preauthContext.setAllowedPaType(paType);
    }

    public Map<String, Object> getCredCache() {
        return this.credCache;
    }

    public void setPreauthRequired(boolean preauthRequired) {
        this.preauthContext.setPreauthRequired(preauthRequired);
    }

    public void resetPrequthContxt() {
        this.preauthContext.reset();
    }

    public PreauthContext getPreauthContext() {
        return this.preauthContext;
    }

    public KdcReq getKdcReq() {
        return this.kdcReq;
    }

    public void setKdcReq(KdcReq kdcReq) {
        this.kdcReq = kdcReq;
    }

    protected KdcReqBody getReqBody(KerberosTime renewTill) throws KrbException {
        if (this.reqBody == null) {
            this.reqBody = this.makeReqBody(renewTill);
        }
        return this.reqBody;
    }

    public KdcRep getKdcRep() {
        return this.kdcRep;
    }

    public void setKdcRep(KdcRep kdcRep) {
        this.kdcRep = kdcRep;
    }

    protected KdcReqBody makeReqBody(KerberosTime renewTill) throws KrbException {
        KerberosTime rtime;
        KdcReqBody body = new KdcReqBody();
        long startTime = System.currentTimeMillis();
        body.setFrom(new KerberosTime(startTime));
        PrincipalName cName = this.getClientPrincipal();
        body.setCname(cName);
        PrincipalName sName = this.getServerPrincipal();
        body.setSname(sName);
        String realm = this.getContext().getKrbSetting().getKdcRealm();
        if (sName != null && sName.getRealm() != null) {
            realm = sName.getRealm();
        }
        body.setRealm(realm);
        long tillTime = startTime + this.getTicketValidTime();
        body.setTill(new KerberosTime(tillTime));
        if (renewTill != null) {
            rtime = renewTill;
        } else {
            long renewLifetime;
            if (this.getRequestOptions().contains(KrbOption.RENEWABLE_TIME)) {
                renewLifetime = this.getRequestOptions().getIntegerOption(KrbOption.RENEWABLE_TIME);
            } else {
                String renewLifetimeStr = this.getContext().getKrbSetting().getKrbConfig().getRenewLifetime();
                renewLifetime = KOptions.parseDuration(renewLifetimeStr);
            }
            rtime = new KerberosTime(startTime + renewLifetime * 1000L);
        }
        body.setRtime(rtime);
        int nonce = this.generateNonce();
        body.setNonce(nonce);
        this.setChosenNonce(nonce);
        body.setKdcOptions(this.getKdcOptions());
        HostAddresses addresses = this.getHostAddresses();
        if (addresses != null) {
            body.setAddresses(addresses);
        }
        body.setEtypes(this.getEncryptionTypes());
        return body;
    }

    public KdcOptions getKdcOptions() {
        return this.kdcOptions;
    }

    public void setKdcOptions(KdcOptions kdcOptions) {
        this.kdcOptions = kdcOptions;
    }

    public HostAddresses getHostAddresses() {
        HostAddresses addresses = null;
        if (!this.hostAddresses.isEmpty()) {
            addresses = new HostAddresses();
            for (HostAddress ha : this.hostAddresses) {
                addresses.addElement(ha);
            }
        }
        return addresses;
    }

    public void setHostAddresses(List<HostAddress> hostAddresses) {
        this.hostAddresses = hostAddresses;
    }

    public KrbContext getContext() {
        return this.context;
    }

    public void setContext(KrbContext context) {
        this.context = context;
    }

    protected byte[] decryptWithClientKey(EncryptedData data, KeyUsage usage) throws KrbException {
        EncryptionKey tmpKey = this.getClientKey();
        if (tmpKey == null) {
            throw new KrbException("Client key isn't availalbe");
        }
        return EncryptionHandler.decrypt(data, tmpKey, usage);
    }

    public abstract PrincipalName getClientPrincipal();

    public PrincipalName getServerPrincipal() {
        return this.serverPrincipal;
    }

    public void setServerPrincipal(PrincipalName serverPrincipal) {
        this.serverPrincipal = serverPrincipal;
    }

    public List<EncryptionType> getEncryptionTypes() {
        if (this.encryptionTypes == null) {
            this.encryptionTypes = this.context.getConfig().getEncryptionTypes();
        }
        return EncryptionUtil.orderEtypesByStrength(this.encryptionTypes);
    }

    public void setEncryptionTypes(List<EncryptionType> encryptionTypes) {
        this.encryptionTypes = encryptionTypes;
    }

    public EncryptionType getChosenEncryptionType() {
        return this.chosenEncryptionType;
    }

    public void setChosenEncryptionType(EncryptionType chosenEncryptionType) {
        this.chosenEncryptionType = chosenEncryptionType;
    }

    public int generateNonce() {
        return this.context.generateNonce();
    }

    public int getChosenNonce() {
        return this.chosenNonce;
    }

    public void setChosenNonce(int nonce) {
        this.chosenNonce = nonce;
    }

    public abstract EncryptionKey getClientKey() throws KrbException;

    public long getTicketValidTime() {
        if (this.getRequestOptions().contains(KrbOption.LIFE_TIME)) {
            return (long)this.getRequestOptions().getIntegerOption(KrbOption.LIFE_TIME) * 1000L;
        }
        return this.context.getTicketValidTime();
    }

    public KerberosTime getTicketTillTime() {
        long now = System.currentTimeMillis();
        return new KerberosTime(now + 3600000000L);
    }

    public void addHost(String hostNameOrIpAddress) throws UnknownHostException {
        InetAddress address = InetAddress.getByName(hostNameOrIpAddress);
        this.hostAddresses.add(new HostAddress(address));
    }

    public void process() throws KrbException {
        this.processKdcOptions();
        this.preauth();
    }

    public abstract void processResponse(KdcRep var1) throws KrbException;

    public KOptions getPreauthOptions() {
        return new KOptions();
    }

    protected void preauth() throws KrbException {
        List<EncryptionType> etypes = this.getEncryptionTypes();
        if (etypes.isEmpty()) {
            throw new KrbException("No encryption type is configured and available");
        }
        EncryptionType encryptionType = etypes.iterator().next();
        this.setChosenEncryptionType(encryptionType);
        this.getPreauthHandler().preauth(this);
    }

    protected PreauthHandler getPreauthHandler() {
        return this.getContext().getPreauthHandler();
    }

    public void needAsKey() throws KrbException {
        EncryptionKey clientKey = this.getClientKey();
        if (clientKey == null) {
            throw new RuntimeException("Client key should be prepared or prompted at this time!");
        }
        this.setAsKey(clientKey);
    }

    public EncryptionType getEncType() {
        return this.getChosenEncryptionType();
    }

    public void askQuestion(String question, String challenge) {
        this.preauthContext.getUserResponser().askQuestion(question, challenge);
    }

    public EncryptionKey getArmorKey() {
        return this.fastRequestState.getArmorKey();
    }

    public KerberosTime getPreauthTime() {
        return KerberosTime.now();
    }

    public Object getCacheValue(String key) {
        return this.credCache.get(key);
    }

    public void cacheValue(String key, Object value) {
        this.credCache.put(key, value);
    }

    protected void processKdcOptions() {
        this.kdcOptions.setFlag(KdcOption.FORWARDABLE);
        this.kdcOptions.setFlag(KdcOption.PROXIABLE);
        this.kdcOptions.setFlag(KdcOption.RENEWABLE_OK);
        for (KOption kOpt : this.requestOptions.getOptions()) {
            if (kOpt.getOptionInfo().getGroup() != KrbOptionGroup.KDC_FLAGS) continue;
            KrbKdcOption krbKdcOption = (KrbKdcOption)kOpt;
            boolean flagValue = this.requestOptions.getBooleanOption(kOpt, true);
            if (kOpt.equals(KrbKdcOption.NOT_FORWARDABLE)) {
                krbKdcOption = KrbKdcOption.FORWARDABLE;
                boolean bl = flagValue = !flagValue;
            }
            if (kOpt.equals(KrbKdcOption.NOT_PROXIABLE)) {
                krbKdcOption = KrbKdcOption.PROXIABLE;
                flagValue = !flagValue;
            }
            KdcOption kdcOption = KdcOption.valueOf(krbKdcOption.name());
            this.kdcOptions.setFlag(kdcOption, flagValue);
        }
    }
}

