/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.crypto.cksum;

import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.KrbException;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.crypto.cksum.AbstractKeyedCheckSumTypeHandler;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.crypto.cksum.provider.Md5Provider;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.crypto.enc.provider.Rc4Provider;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.crypto.util.Hmac;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.crypto.util.Rc4;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.CheckSumType;

public class Md5HmacRc4CheckSum
extends AbstractKeyedCheckSumTypeHandler {
    public Md5HmacRc4CheckSum() {
        super(new Rc4Provider(), new Md5Provider(), 16, 16);
    }

    @Override
    public int confounderSize() {
        return 8;
    }

    @Override
    public CheckSumType cksumType() {
        return CheckSumType.MD5_HMAC_ARCFOUR;
    }

    @Override
    public boolean isSafe() {
        return true;
    }

    @Override
    public int cksumSize() {
        return 16;
    }

    @Override
    public int keySize() {
        return 16;
    }

    @Override
    protected byte[] doChecksumWithKey(byte[] data, int start, int len, byte[] key, int usage) throws KrbException {
        byte[] ksign = key;
        byte[] salt = Rc4.getSalt(usage, false);
        this.hashProvider().hash(salt);
        this.hashProvider().hash(data, start, len);
        byte[] hashTmp = this.hashProvider().output();
        return Hmac.hmac(this.hashProvider(), ksign, hashTmp);
    }
}

