/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.crypto.dh;

import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.crypto.EncTypeHandler;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.crypto.EncryptionHandler;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.crypto.dh.OctetString2Key;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.EncryptionKey;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.EncryptionType;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.KeyUsage;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.KeyAgreement;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;

public class DiffieHellmanServer {
    private KeyAgreement serverKeyAgree;
    private EncryptionKey serverKey;

    public PublicKey initAndDoPhase(byte[] clientPubKeyEnc) throws Exception {
        KeyFactory serverKeyFac = KeyFactory.getInstance("DH");
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(clientPubKeyEnc);
        PublicKey clientPubKey = serverKeyFac.generatePublic(x509KeySpec);
        DHParameterSpec dhParamSpec = ((DHPublicKey)clientPubKey).getParams();
        KeyPairGenerator serverKpairGen = KeyPairGenerator.getInstance("DH");
        serverKpairGen.initialize(dhParamSpec);
        KeyPair serverKpair = serverKpairGen.generateKeyPair();
        this.serverKeyAgree = KeyAgreement.getInstance("DH");
        this.serverKeyAgree.init(serverKpair.getPrivate());
        this.serverKeyAgree.doPhase(clientPubKey, true);
        return serverKpair.getPublic();
    }

    public EncryptionKey generateKey(byte[] clientDhNonce, byte[] serverDhNonce, EncryptionType type) {
        byte[] dhSharedSecret;
        byte[] x = dhSharedSecret = this.serverKeyAgree.generateSecret();
        if (clientDhNonce != null && clientDhNonce.length > 0 && serverDhNonce != null && serverDhNonce.length > 0) {
            x = this.concatenateBytes(dhSharedSecret, clientDhNonce);
            x = this.concatenateBytes(x, serverDhNonce);
        }
        byte[] secret = OctetString2Key.kTruncate(dhSharedSecret.length, x);
        this.serverKey = new EncryptionKey(type, secret);
        return this.serverKey;
    }

    public byte[] encrypt(byte[] clearText, KeyUsage usage) throws Exception {
        EncTypeHandler encType = EncryptionHandler.getEncHandler(this.serverKey.getKeyType());
        return encType.encrypt(clearText, this.serverKey.getKeyData(), usage.getValue());
    }

    private byte[] concatenateBytes(byte[] array1, byte[] array2) {
        byte[] concatenatedBytes = new byte[array1.length + array2.length];
        System.arraycopy(array1, 0, concatenatedBytes, 0, array1.length);
        for (int j = array1.length; j < concatenatedBytes.length; ++j) {
            concatenatedBytes[j] = array2[j - array1.length];
        }
        return concatenatedBytes;
    }
}

