/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.crypto.enc.provider;

import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.KrbException;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.crypto.enc.provider.AbstractEncryptProvider;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.crypto.util.Camellia;

public abstract class CamelliaProvider
extends AbstractEncryptProvider {
    public CamelliaProvider(int blockSize, int keyInputSize, int keySize) {
        super(blockSize, keyInputSize, keySize);
    }

    @Override
    protected void doEncrypt(byte[] data, byte[] key, byte[] cipherState, boolean encrypt) throws KrbException {
        Camellia cipher = new Camellia();
        cipher.setKey(encrypt, key);
        if (encrypt) {
            cipher.encrypt(data, cipherState);
        } else {
            cipher.decrypt(data, cipherState);
        }
    }

    @Override
    public boolean supportCbcMac() {
        return true;
    }

    @Override
    public byte[] cbcMac(byte[] key, byte[] cipherState, byte[] data) {
        Camellia cipher = new Camellia();
        cipher.setKey(true, key);
        int blocksNum = data.length / this.blockSize();
        cipher.cbcEnc(data, 0, blocksNum, cipherState);
        return data;
    }
}

