/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.server;

import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.common.Krb5Conf;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.server.KdcConfigKey;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.EncryptionType;
import java.util.Arrays;
import java.util.List;

public class KdcConfig
extends Krb5Conf {
    private static final String KDCDEFAULT = "kdcdefaults";

    public boolean enableDebug() {
        return this.getBoolean(KdcConfigKey.KRB_DEBUG, true, KDCDEFAULT);
    }

    public String getKdcServiceName() {
        return this.getString(KdcConfigKey.KDC_SERVICE_NAME, true, KDCDEFAULT);
    }

    public String getKdcHost() {
        return this.getString(KdcConfigKey.KDC_HOST, true, KDCDEFAULT);
    }

    public int getKdcPort() {
        Integer kdcPort = this.getInt(KdcConfigKey.KDC_PORT, true, KDCDEFAULT);
        if (kdcPort != null && kdcPort > 0) {
            return kdcPort;
        }
        return -1;
    }

    public int getKdcTcpPort() {
        Integer kdcTcpPort = this.getInt(KdcConfigKey.KDC_TCP_PORT, true, KDCDEFAULT);
        if (kdcTcpPort != null && kdcTcpPort > 0) {
            return kdcTcpPort;
        }
        return this.getKdcPort();
    }

    public Boolean allowTcp() {
        return this.getBoolean(KdcConfigKey.KDC_ALLOW_TCP, true, KDCDEFAULT) != false || this.getInt(KdcConfigKey.KDC_TCP_PORT, true, KDCDEFAULT) != null || this.getInt(KdcConfigKey.KDC_PORT, false, KDCDEFAULT) != null;
    }

    public Boolean allowUdp() {
        return this.getBoolean(KdcConfigKey.KDC_ALLOW_UDP, true, KDCDEFAULT) != false || this.getInt(KdcConfigKey.KDC_UDP_PORT, true, KDCDEFAULT) != null || this.getInt(KdcConfigKey.KDC_PORT, false, KDCDEFAULT) != null;
    }

    public int getKdcUdpPort() {
        Integer kdcUdpPort = this.getInt(KdcConfigKey.KDC_UDP_PORT, true, KDCDEFAULT);
        if (kdcUdpPort != null && kdcUdpPort > 0) {
            return kdcUdpPort;
        }
        return this.getKdcPort();
    }

    public String getKdcRealm() {
        return this.getString(KdcConfigKey.KDC_REALM, true, KDCDEFAULT);
    }

    public String getKdcDomain() {
        return this.getString(KdcConfigKey.KDC_DOMAIN, true, KDCDEFAULT);
    }

    public boolean isPreauthRequired() {
        return this.getBoolean(KdcConfigKey.PREAUTH_REQUIRED, true, KDCDEFAULT);
    }

    public boolean isAllowTokenPreauth() {
        return this.getBoolean(KdcConfigKey.ALLOW_TOKEN_PREAUTH, true, KDCDEFAULT);
    }

    public long getAllowableClockSkew() {
        return this.getLong(KdcConfigKey.ALLOWABLE_CLOCKSKEW, true, KDCDEFAULT);
    }

    public boolean isEmptyAddressesAllowed() {
        return this.getBoolean(KdcConfigKey.EMPTY_ADDRESSES_ALLOWED, true, KDCDEFAULT);
    }

    public boolean isForwardableAllowed() {
        return this.getBoolean(KdcConfigKey.FORWARDABLE_ALLOWED, true, KDCDEFAULT);
    }

    public boolean isPostdatedAllowed() {
        return this.getBoolean(KdcConfigKey.POSTDATED_ALLOWED, true, KDCDEFAULT);
    }

    public boolean isProxiableAllowed() {
        return this.getBoolean(KdcConfigKey.PROXIABLE_ALLOWED, true, KDCDEFAULT);
    }

    public boolean isRenewableAllowed() {
        return this.getBoolean(KdcConfigKey.RENEWABLE_ALLOWED, true, KDCDEFAULT);
    }

    public long getMaximumRenewableLifetime() {
        return this.getLong(KdcConfigKey.MAXIMUM_RENEWABLE_LIFETIME, true, KDCDEFAULT);
    }

    public long getMaximumTicketLifetime() {
        return this.getLong(KdcConfigKey.MAXIMUM_TICKET_LIFETIME, true, KDCDEFAULT);
    }

    public long getMinimumTicketLifetime() {
        return this.getLong(KdcConfigKey.MINIMUM_TICKET_LIFETIME, true, KDCDEFAULT);
    }

    public List<EncryptionType> getEncryptionTypes() {
        return this.getEncTypes(KdcConfigKey.ENCRYPTION_TYPES, true, KDCDEFAULT);
    }

    public boolean isPaEncTimestampRequired() {
        return this.getBoolean(KdcConfigKey.PA_ENC_TIMESTAMP_REQUIRED, true, KDCDEFAULT);
    }

    public boolean isBodyChecksumVerified() {
        return this.getBoolean(KdcConfigKey.VERIFY_BODY_CHECKSUM, true, KDCDEFAULT);
    }

    public boolean isRestrictAnonymousToTgt() {
        return this.getBoolean(KdcConfigKey.RESTRICT_ANONYMOUS_TO_TGT, true, KDCDEFAULT);
    }

    public int getKdcMaxDgramReplySize() {
        return this.getInt(KdcConfigKey.KDC_MAX_DGRAM_REPLY_SIZE, true, KDCDEFAULT);
    }

    public String getVerifyKeyConfig() {
        return this.getString(KdcConfigKey.TOKEN_VERIFY_KEYS, true, KDCDEFAULT);
    }

    public String getDecryptionKeyConfig() {
        return this.getString(KdcConfigKey.TOKEN_DECRYPTION_KEYS, true, KDCDEFAULT);
    }

    public List<String> getIssuers() {
        return Arrays.asList(this.getStringArray(KdcConfigKey.TOKEN_ISSUERS, true, KDCDEFAULT));
    }

    public List<String> getPkinitAnchors() {
        return Arrays.asList(this.getString(KdcConfigKey.PKINIT_ANCHORS, true, KDCDEFAULT));
    }

    public String getPkinitIdentity() {
        return this.getString(KdcConfigKey.PKINIT_IDENTITY, true, KDCDEFAULT);
    }
}

