/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.transport;

import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.transport.AbstractKrbTransport;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.transport.KrbTransport;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.ByteBuffer;

public class KrbTcpTransport
extends AbstractKrbTransport
implements KrbTransport {
    private Socket socket;
    private DataOutputStream outputStream;
    private DataInputStream inputStream;
    private byte[] messageBuffer;

    public KrbTcpTransport(Socket socket) throws IOException {
        this.socket = socket;
        this.outputStream = new DataOutputStream(socket.getOutputStream());
        this.inputStream = new DataInputStream(socket.getInputStream());
        this.messageBuffer = new byte[0x400000];
    }

    @Override
    public void sendMessage(ByteBuffer message) throws IOException {
        this.outputStream.write(message.array());
    }

    @Override
    public ByteBuffer receiveMessage() throws IOException {
        int msgLen = this.inputStream.readInt();
        if (msgLen > 0) {
            if (msgLen > this.messageBuffer.length) {
                throw new IOException("Recv buffer overflowed, too large message?");
            }
            this.inputStream.readFully(this.messageBuffer, 0, msgLen);
            return ByteBuffer.wrap(this.messageBuffer, 0, msgLen);
        }
        return null;
    }

    @Override
    public boolean isTcp() {
        return true;
    }

    @Override
    public InetAddress getRemoteAddress() {
        return this.socket.getInetAddress();
    }

    @Override
    public void release() {
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean isClosed() {
        return this.socket.isClosed();
    }
}

