/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.ad;

import io.hops.hadoop.shaded.org.apache.kerby.asn1.Asn1Dumper;
import io.hops.hadoop.shaded.org.apache.kerby.asn1.Asn1FieldInfo;
import io.hops.hadoop.shaded.org.apache.kerby.asn1.EnumType;
import io.hops.hadoop.shaded.org.apache.kerby.asn1.ExplicitField;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.KrbSequenceType;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.ad.AuthorizationData;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.ad.AuthorizationDataEntry;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.ad.AuthorizationType;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.ad.CamMacOtherVerifiers;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.ad.CamMacVerifierMac;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ADCamMac
extends AuthorizationDataEntry {
    private static final Logger LOG = LoggerFactory.getLogger(ADCamMac.class);
    private CamMac myCamMac = new CamMac();

    public ADCamMac() {
        super(AuthorizationType.AD_CAMMAC);
        this.myCamMac.outerEncodeable = this;
    }

    public ADCamMac(byte[] encoded) throws IOException {
        this();
        this.myCamMac.decode(encoded);
    }

    public AuthorizationData getAuthorizationData() {
        return this.myCamMac.getAuthorizationData();
    }

    public void setAuthorizationData(AuthorizationData authzData) {
        this.myCamMac.setAuthorizationData(authzData);
    }

    public CamMacVerifierMac getKdcVerifier() {
        return this.myCamMac.getKdcVerifier();
    }

    public void setKdcVerifier(CamMacVerifierMac kdcVerifier) {
        this.myCamMac.setKdcVerifier(kdcVerifier);
    }

    public CamMacVerifierMac getSvcVerifier() {
        return this.myCamMac.getSvcVerifier();
    }

    public void setSvcVerifier(CamMacVerifierMac svcVerifier) {
        this.myCamMac.setSvcVerifier(svcVerifier);
    }

    public CamMacOtherVerifiers getOtherVerifiers() {
        return this.myCamMac.getOtherVerifiers();
    }

    public void setOtherVerifiers(CamMacOtherVerifiers otherVerifiers) {
        this.myCamMac.setOtherVerifiers(otherVerifiers);
    }

    @Override
    protected int encodingBodyLength() throws IOException {
        if (this.bodyLength == -1) {
            this.setAuthzData(this.myCamMac.encode());
            this.bodyLength = super.encodingBodyLength();
        }
        return this.bodyLength;
    }

    @Override
    public void dumpWith(Asn1Dumper dumper, int indents) {
        try {
            this.setAuthzData(this.myCamMac.encode());
        }
        catch (IOException e) {
            LOG.error("Failed to set the AD_DATA field. " + e.toString());
        }
        super.dumpWith(dumper, indents);
        dumper.newLine();
        this.myCamMac.dumpWith(dumper, indents + 8);
    }

    private static class CamMac
    extends KrbSequenceType {
        private static Asn1FieldInfo[] fieldInfos = new Asn1FieldInfo[]{new ExplicitField(CamMacField.CAMMAC_elements, AuthorizationData.class), new ExplicitField(CamMacField.CAMMAC_kdc_verifier, CamMacVerifierMac.class), new ExplicitField(CamMacField.CAMMAC_svc_verifier, CamMacVerifierMac.class), new ExplicitField(CamMacField.CAMMAC_other_verifiers, CamMacOtherVerifiers.class)};

        CamMac() {
            super(fieldInfos);
        }

        CamMac(byte[] authzFields) {
            super(fieldInfos);
            super.setFieldAsOctets(AuthorizationDataEntry.AuthorizationDataEntryField.AD_DATA, authzFields);
        }

        CamMac(AuthorizationData authzData) {
            super(fieldInfos);
            this.setFieldAs(CamMacField.CAMMAC_elements, authzData);
        }

        public AuthorizationData getAuthorizationData() {
            return this.getFieldAs(CamMacField.CAMMAC_elements, AuthorizationData.class);
        }

        public void setAuthorizationData(AuthorizationData authzData) {
            this.setFieldAs(CamMacField.CAMMAC_elements, authzData);
            this.resetBodyLength();
        }

        public CamMacVerifierMac getKdcVerifier() {
            return this.getFieldAs(CamMacField.CAMMAC_kdc_verifier, CamMacVerifierMac.class);
        }

        public void setKdcVerifier(CamMacVerifierMac kdcVerifier) {
            this.setFieldAs(CamMacField.CAMMAC_kdc_verifier, kdcVerifier);
            this.resetBodyLength();
        }

        public CamMacVerifierMac getSvcVerifier() {
            return this.getFieldAs(CamMacField.CAMMAC_svc_verifier, CamMacVerifierMac.class);
        }

        public void setSvcVerifier(CamMacVerifierMac svcVerifier) {
            this.setFieldAs(CamMacField.CAMMAC_svc_verifier, svcVerifier);
            this.resetBodyLength();
        }

        public CamMacOtherVerifiers getOtherVerifiers() {
            return this.getFieldAs(CamMacField.CAMMAC_other_verifiers, CamMacOtherVerifiers.class);
        }

        public void setOtherVerifiers(CamMacOtherVerifiers svcVerifier) {
            this.setFieldAs(CamMacField.CAMMAC_other_verifiers, svcVerifier);
            this.resetBodyLength();
        }

        protected static enum CamMacField implements EnumType
        {
            CAMMAC_elements,
            CAMMAC_kdc_verifier,
            CAMMAC_svc_verifier,
            CAMMAC_other_verifiers;


            @Override
            public int getValue() {
                return this.ordinal();
            }

            @Override
            public String getName() {
                return this.name();
            }
        }
    }
}

