/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.jline.builtins.ssh;

import io.hops.hadoop.shaded.org.apache.sshd.server.Environment;
import io.hops.hadoop.shaded.org.apache.sshd.server.ExitCallback;
import io.hops.hadoop.shaded.org.apache.sshd.server.channel.ChannelSession;
import io.hops.hadoop.shaded.org.apache.sshd.server.command.Command;
import io.hops.hadoop.shaded.org.apache.sshd.server.session.ServerSession;
import io.hops.hadoop.shaded.org.jline.builtins.ssh.ShellFactoryImpl;
import io.hops.hadoop.shaded.org.jline.builtins.ssh.Ssh;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ShellCommand
implements Command {
    private static final Logger LOGGER = Logger.getLogger(ShellCommand.class.getName());
    private final Consumer<Ssh.ExecuteParams> execute;
    private final String command;
    private InputStream in;
    private OutputStream out;
    private OutputStream err;
    private ExitCallback callback;
    private ServerSession session;
    private Environment env;

    public ShellCommand(Consumer<Ssh.ExecuteParams> execute, String command) {
        this.execute = execute;
        this.command = command;
    }

    public void setInputStream(InputStream in) {
        this.in = in;
    }

    public void setOutputStream(OutputStream out) {
        this.out = out;
    }

    public void setErrorStream(OutputStream err) {
        this.err = err;
    }

    public void setExitCallback(ExitCallback callback) {
        this.callback = callback;
    }

    public void start(ChannelSession channel, Environment env) throws IOException {
        this.session = channel.getSession();
        this.env = env;
        new Thread(this::run).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() {
        int exitStatus = 0;
        try {
            this.execute.accept(new Ssh.ExecuteParams(this.command, this.env.getEnv(), this.session, this.in, this.out, this.err));
        }
        catch (RuntimeException e) {
            try {
                exitStatus = 1;
                LOGGER.log(Level.SEVERE, "Unable to start shell", e);
                try {
                    Throwable t = e.getCause() != null ? e.getCause() : e;
                    this.err.write(t.toString().getBytes());
                    this.err.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            catch (Throwable throwable) {
                ShellFactoryImpl.close(this.in, this.out, this.err);
                this.callback.onExit(exitStatus);
                throw throwable;
            }
            ShellFactoryImpl.close(this.in, this.out, this.err);
            this.callback.onExit(exitStatus);
        }
        ShellFactoryImpl.close(this.in, this.out, this.err);
        this.callback.onExit(exitStatus);
    }

    public void destroy(ChannelSession channel) {
    }
}

