/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.jline.terminal.impl.exec;

import io.hops.hadoop.shaded.org.jline.terminal.Attributes;
import io.hops.hadoop.shaded.org.jline.terminal.Size;
import io.hops.hadoop.shaded.org.jline.terminal.Terminal;
import io.hops.hadoop.shaded.org.jline.terminal.impl.ExecPty;
import io.hops.hadoop.shaded.org.jline.terminal.impl.ExternalTerminal;
import io.hops.hadoop.shaded.org.jline.terminal.impl.PosixSysTerminal;
import io.hops.hadoop.shaded.org.jline.terminal.spi.Pty;
import io.hops.hadoop.shaded.org.jline.terminal.spi.TerminalProvider;
import io.hops.hadoop.shaded.org.jline.utils.ExecHelper;
import io.hops.hadoop.shaded.org.jline.utils.OSUtils;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.nio.charset.Charset;

public class ExecTerminalProvider
implements TerminalProvider {
    @Override
    public String name() {
        return "exec";
    }

    public Pty current(TerminalProvider.Stream consoleStream) throws IOException {
        return ExecPty.current(consoleStream);
    }

    @Override
    public Terminal sysTerminal(String name, String type, boolean ansiPassThrough, Charset encoding, boolean nativeSignals, Terminal.SignalHandler signalHandler, boolean paused, TerminalProvider.Stream consoleStream) throws IOException {
        if (OSUtils.IS_WINDOWS) {
            return this.winSysTerminal(name, type, ansiPassThrough, encoding, nativeSignals, signalHandler, paused, consoleStream);
        }
        return this.posixSysTerminal(name, type, ansiPassThrough, encoding, nativeSignals, signalHandler, paused, consoleStream);
    }

    public Terminal winSysTerminal(String name, String type, boolean ansiPassThrough, Charset encoding, boolean nativeSignals, Terminal.SignalHandler signalHandler, boolean paused, TerminalProvider.Stream consoleStream) throws IOException {
        if (OSUtils.IS_CYGWIN || OSUtils.IS_MSYSTEM) {
            Pty pty = this.current(consoleStream);
            return new PosixSysTerminal(name, type, pty, encoding, nativeSignals, signalHandler);
        }
        return null;
    }

    public Terminal posixSysTerminal(String name, String type, boolean ansiPassThrough, Charset encoding, boolean nativeSignals, Terminal.SignalHandler signalHandler, boolean paused, TerminalProvider.Stream consoleStream) throws IOException {
        Pty pty = this.current(consoleStream);
        return new PosixSysTerminal(name, type, pty, encoding, nativeSignals, signalHandler);
    }

    @Override
    public Terminal newTerminal(String name, String type, InputStream in, OutputStream out, Charset encoding, Terminal.SignalHandler signalHandler, boolean paused, Attributes attributes, Size size) throws IOException {
        return new ExternalTerminal(name, type, in, out, encoding, signalHandler, paused, attributes, size);
    }

    @Override
    public boolean isSystemStream(TerminalProvider.Stream stream) {
        try {
            return this.isWindowsSystemStream(stream) || this.isPosixSystemStream(stream);
        }
        catch (Throwable t) {
            return false;
        }
    }

    public boolean isWindowsSystemStream(TerminalProvider.Stream stream) {
        return this.systemStreamName(stream) != null;
    }

    public boolean isPosixSystemStream(TerminalProvider.Stream stream) {
        try {
            Process p = new ProcessBuilder(OSUtils.TEST_COMMAND, "-t", Integer.toString(stream.ordinal())).inheritIO().start();
            return p.waitFor() == 0;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    @Override
    public String systemStreamName(TerminalProvider.Stream stream) {
        try {
            ProcessBuilder.Redirect input = stream == TerminalProvider.Stream.Input ? ProcessBuilder.Redirect.INHERIT : this.getRedirect(stream == TerminalProvider.Stream.Output ? FileDescriptor.out : FileDescriptor.err);
            Process p = new ProcessBuilder(OSUtils.TTY_COMMAND).redirectInput(input).start();
            String result = ExecHelper.waitAndCapture(p);
            if (p.exitValue() == 0) {
                return result.trim();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private ProcessBuilder.Redirect getRedirect(FileDescriptor fd) throws ReflectiveOperationException {
        Class<?> rpi = Class.forName("java.lang.ProcessBuilder$RedirectPipeImpl");
        Constructor<?> cns = rpi.getDeclaredConstructor(new Class[0]);
        cns.setAccessible(true);
        ProcessBuilder.Redirect input = (ProcessBuilder.Redirect)cns.newInstance(new Object[0]);
        Field f = rpi.getDeclaredField("fd");
        f.setAccessible(true);
        f.set(input, fd);
        return input;
    }
}

