/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.jline.terminal.impl.jna;

import io.hops.hadoop.shaded.org.jline.terminal.Attributes;
import io.hops.hadoop.shaded.org.jline.terminal.Size;
import io.hops.hadoop.shaded.org.jline.terminal.Terminal;
import io.hops.hadoop.shaded.org.jline.terminal.impl.PosixPtyTerminal;
import io.hops.hadoop.shaded.org.jline.terminal.impl.PosixSysTerminal;
import io.hops.hadoop.shaded.org.jline.terminal.impl.jna.JnaNativePty;
import io.hops.hadoop.shaded.org.jline.terminal.impl.jna.win.JnaWinSysTerminal;
import io.hops.hadoop.shaded.org.jline.terminal.spi.Pty;
import io.hops.hadoop.shaded.org.jline.terminal.spi.TerminalProvider;
import io.hops.hadoop.shaded.org.jline.utils.OSUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;

public class JnaTerminalProvider
implements TerminalProvider {
    @Override
    public String name() {
        return "jna";
    }

    public Pty current(TerminalProvider.Stream console) throws IOException {
        return JnaNativePty.current(console);
    }

    public Pty open(Attributes attributes, Size size) throws IOException {
        return JnaNativePty.open(attributes, size);
    }

    @Override
    public Terminal sysTerminal(String name, String type, boolean ansiPassThrough, Charset encoding, boolean nativeSignals, Terminal.SignalHandler signalHandler, boolean paused, TerminalProvider.Stream consoleStream) throws IOException {
        if (OSUtils.IS_WINDOWS) {
            return this.winSysTerminal(name, type, ansiPassThrough, encoding, nativeSignals, signalHandler, paused, consoleStream);
        }
        return this.posixSysTerminal(name, type, ansiPassThrough, encoding, nativeSignals, signalHandler, paused, consoleStream);
    }

    public Terminal winSysTerminal(String name, String type, boolean ansiPassThrough, Charset encoding, boolean nativeSignals, Terminal.SignalHandler signalHandler, boolean paused, TerminalProvider.Stream console) throws IOException {
        return JnaWinSysTerminal.createTerminal(name, type, ansiPassThrough, encoding, nativeSignals, signalHandler, paused, console);
    }

    public Terminal posixSysTerminal(String name, String type, boolean ansiPassThrough, Charset encoding, boolean nativeSignals, Terminal.SignalHandler signalHandler, boolean paused, TerminalProvider.Stream consoleStream) throws IOException {
        Pty pty = this.current(consoleStream);
        return new PosixSysTerminal(name, type, pty, encoding, nativeSignals, signalHandler);
    }

    @Override
    public Terminal newTerminal(String name, String type, InputStream in, OutputStream out, Charset encoding, Terminal.SignalHandler signalHandler, boolean paused, Attributes attributes, Size size) throws IOException {
        Pty pty = this.open(attributes, size);
        return new PosixPtyTerminal(name, type, pty, in, out, encoding, signalHandler, paused);
    }

    @Override
    public boolean isSystemStream(TerminalProvider.Stream stream) {
        try {
            if (OSUtils.IS_WINDOWS) {
                return this.isWindowsSystemStream(stream);
            }
            return this.isPosixSystemStream(stream);
        }
        catch (Throwable t) {
            return false;
        }
    }

    public boolean isWindowsSystemStream(TerminalProvider.Stream stream) {
        return JnaWinSysTerminal.isWindowsSystemStream(stream);
    }

    public boolean isPosixSystemStream(TerminalProvider.Stream stream) {
        return JnaNativePty.isPosixSystemStream(stream);
    }

    @Override
    public String systemStreamName(TerminalProvider.Stream stream) {
        if (OSUtils.IS_WINDOWS) {
            return null;
        }
        return JnaNativePty.posixSystemStreamName(stream);
    }
}

