/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.xbill.DNS;

import io.hops.hadoop.shaded.org.xbill.DNS.Address;
import io.hops.hadoop.shaded.org.xbill.DNS.Compression;
import io.hops.hadoop.shaded.org.xbill.DNS.DNSInput;
import io.hops.hadoop.shaded.org.xbill.DNS.DNSOutput;
import io.hops.hadoop.shaded.org.xbill.DNS.Name;
import io.hops.hadoop.shaded.org.xbill.DNS.Record;
import io.hops.hadoop.shaded.org.xbill.DNS.Tokenizer;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class ARecord
extends Record {
    private static final long serialVersionUID = -2172609200849142323L;
    private int addr;

    ARecord() {
    }

    Record getObject() {
        return new ARecord();
    }

    private static final int fromArray(byte[] array) {
        return (array[0] & 0xFF) << 24 | (array[1] & 0xFF) << 16 | (array[2] & 0xFF) << 8 | array[3] & 0xFF;
    }

    private static final byte[] toArray(int addr) {
        byte[] bytes = new byte[]{(byte)(addr >>> 24 & 0xFF), (byte)(addr >>> 16 & 0xFF), (byte)(addr >>> 8 & 0xFF), (byte)(addr & 0xFF)};
        return bytes;
    }

    public ARecord(Name name, int dclass, long ttl, InetAddress address) {
        super(name, 1, dclass, ttl);
        if (Address.familyOf(address) != 1) {
            throw new IllegalArgumentException("invalid IPv4 address");
        }
        this.addr = ARecord.fromArray(address.getAddress());
    }

    void rrFromWire(DNSInput in) throws IOException {
        this.addr = ARecord.fromArray(in.readByteArray(4));
    }

    void rdataFromString(Tokenizer st, Name origin) throws IOException {
        this.addr = ARecord.fromArray(st.getAddressBytes(1));
    }

    String rrToString() {
        return Address.toDottedQuad(ARecord.toArray(this.addr));
    }

    public InetAddress getAddress() {
        try {
            if (this.name == null) {
                return InetAddress.getByAddress(ARecord.toArray(this.addr));
            }
            return InetAddress.getByAddress(this.name.toString(), ARecord.toArray(this.addr));
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    void rrToWire(DNSOutput out, Compression c, boolean canonical) {
        out.writeU32((long)this.addr & 0xFFFFFFFFL);
    }
}

