/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.xbill.DNS;

import io.hops.hadoop.shaded.org.xbill.DNS.Compression;
import io.hops.hadoop.shaded.org.xbill.DNS.DNSInput;
import io.hops.hadoop.shaded.org.xbill.DNS.DNSOutput;
import io.hops.hadoop.shaded.org.xbill.DNS.Name;
import io.hops.hadoop.shaded.org.xbill.DNS.Record;
import io.hops.hadoop.shaded.org.xbill.DNS.TextParseException;
import io.hops.hadoop.shaded.org.xbill.DNS.Tokenizer;
import java.io.IOException;

public class HINFORecord
extends Record {
    private static final long serialVersionUID = -4732870630947452112L;
    private byte[] cpu;
    private byte[] os;

    HINFORecord() {
    }

    Record getObject() {
        return new HINFORecord();
    }

    public HINFORecord(Name name, int dclass, long ttl, String cpu, String os) {
        super(name, 13, dclass, ttl);
        try {
            this.cpu = HINFORecord.byteArrayFromString(cpu);
            this.os = HINFORecord.byteArrayFromString(os);
        }
        catch (TextParseException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    void rrFromWire(DNSInput in) throws IOException {
        this.cpu = in.readCountedString();
        this.os = in.readCountedString();
    }

    void rdataFromString(Tokenizer st, Name origin) throws IOException {
        try {
            this.cpu = HINFORecord.byteArrayFromString(st.getString());
            this.os = HINFORecord.byteArrayFromString(st.getString());
        }
        catch (TextParseException e) {
            throw st.exception(e.getMessage());
        }
    }

    public String getCPU() {
        return HINFORecord.byteArrayToString(this.cpu, false);
    }

    public String getOS() {
        return HINFORecord.byteArrayToString(this.os, false);
    }

    void rrToWire(DNSOutput out, Compression c, boolean canonical) {
        out.writeCountedString(this.cpu);
        out.writeCountedString(this.os);
    }

    String rrToString() {
        StringBuffer sb = new StringBuffer();
        sb.append(HINFORecord.byteArrayToString(this.cpu, true));
        sb.append(" ");
        sb.append(HINFORecord.byteArrayToString(this.os, true));
        return sb.toString();
    }
}

