/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.com.logicalclocks.servicediscoverclient;

import io.hops.hadoop.shaded.com.logicalclocks.servicediscoverclient.ServiceDiscoveryClient;
import io.hops.hadoop.shaded.com.logicalclocks.servicediscoverclient.exceptions.ServiceDiscoveryException;
import io.hops.hadoop.shaded.com.logicalclocks.servicediscoverclient.resolvers.CachingResolver;
import io.hops.hadoop.shaded.com.logicalclocks.servicediscoverclient.resolvers.DnsResolver;
import io.hops.hadoop.shaded.com.logicalclocks.servicediscoverclient.resolvers.HttpResolver;
import io.hops.hadoop.shaded.com.logicalclocks.servicediscoverclient.resolvers.Type;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul.Consul;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;

public class Builder {
    private final Type resolverType;
    private String httpHost = "localhost";
    private Integer httpPort = 8500;
    private Boolean https = false;
    private SSLContext sslContext;
    private HostnameVerifier hostnameVerifier;
    private Consul client;
    private String dnsHost = null;
    private Integer dnsPort = null;
    private ServiceDiscoveryClient serviceDiscoveryClient;
    private Duration cacheExpiration = Duration.of(1L, ChronoUnit.MINUTES);

    public Builder(Type resolverType) {
        this.resolverType = resolverType;
    }

    public Builder withHttpHost(String httpHost) {
        this.httpHost = httpHost;
        return this;
    }

    public Builder withHttpPort(Integer httpPort) {
        this.httpPort = httpPort;
        return this;
    }

    public Builder withHttps() {
        this.https = true;
        return this;
    }

    public Builder withSSLContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    public Builder withHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
        return this;
    }

    public Builder withClient(Consul client) {
        this.client = client;
        return this;
    }

    public Builder withDnsHost(String dnsHost) {
        this.dnsHost = dnsHost;
        return this;
    }

    public Builder withDnsPort(Integer dnsPort) {
        this.dnsPort = dnsPort;
        return this;
    }

    public Builder withServiceDiscoveryClient(ServiceDiscoveryClient serviceDiscoveryClient) {
        this.serviceDiscoveryClient = serviceDiscoveryClient;
        return this;
    }

    public Builder withCacheExpiration(Duration cacheExpiration) {
        this.cacheExpiration = cacheExpiration;
        return this;
    }

    public String getHttpHost() {
        return this.httpHost;
    }

    public Integer getHttpPort() {
        return this.httpPort;
    }

    public Boolean getHttps() {
        return this.https;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public Consul getClient() {
        return this.client;
    }

    public String getDnsHost() {
        return this.dnsHost;
    }

    public Integer getDnsPort() {
        return this.dnsPort;
    }

    public ServiceDiscoveryClient getServiceDiscoveryClient() {
        return this.serviceDiscoveryClient;
    }

    public Duration getCacheExpiration() {
        return this.cacheExpiration;
    }

    public ServiceDiscoveryClient build() throws ServiceDiscoveryException {
        ServiceDiscoveryClient client;
        switch (this.resolverType) {
            case DNS: {
                client = new DnsResolver();
                break;
            }
            case HTTP: {
                client = new HttpResolver();
                break;
            }
            case CACHING: {
                client = new CachingResolver();
                break;
            }
            default: {
                throw new RuntimeException("Unknown service discovery resolver type: " + (Object)((Object)this.resolverType));
            }
        }
        client.init(this);
        return client;
    }
}

