/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul.option;

import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;

public class ConsistencyMode {
    public static final ConsistencyMode DEFAULT = new ConsistencyMode("DEFAULT", 0, null);
    public static final ConsistencyMode STALE = new ConsistencyMode("STALE", 1, "stale");
    public static final ConsistencyMode CONSISTENT = new ConsistencyMode("CONSISTENT", 2, "consistent");
    private final String name;
    private final int ordinal;
    private final String param;
    private final Map<String, String> additionalHeaders;

    private ConsistencyMode(String name, int ordinal, String param) {
        this(name, ordinal, param, Collections.emptyMap());
    }

    private ConsistencyMode(String name, int ordinal, String param, Map<String, String> headers) {
        this.name = name;
        this.ordinal = ordinal;
        this.param = param;
        this.additionalHeaders = headers;
    }

    public final Optional<String> toParam() {
        return Optional.ofNullable(this.param);
    }

    public final Map<String, String> getAdditionalHeaders() {
        return this.additionalHeaders;
    }

    public static final ConsistencyMode createCachedConsistencyWithMaxAgeAndStale(Optional<Long> maxAgeInSeconds, Optional<Long> maxStaleInSeconds) {
        long v;
        String maxAge = "";
        if (maxAgeInSeconds.isPresent()) {
            v = maxAgeInSeconds.get();
            if (v < 0L) {
                throw new IllegalArgumentException("maxAgeInSeconds must greater or equal to 0");
            }
            maxAge = maxAge + String.format("max-age=%d", v);
        }
        if (maxStaleInSeconds.isPresent()) {
            v = maxStaleInSeconds.get();
            if (v < 0L) {
                throw new IllegalArgumentException("maxStaleInSeconds must greater or equal to 0");
            }
            if (!maxAge.isEmpty()) {
                maxAge = maxAge + ",";
            }
            maxAge = maxAge + String.format("stale-if-error=%d", v);
        }
        Map<String, String> headers = maxAge.isEmpty() ? Collections.emptyMap() : ImmutableMap.of("Cache-Control", maxAge);
        return new ConsistencyMode("CACHED", 3, "cached", headers);
    }

    public final String name() {
        return this.name;
    }

    public final String toString() {
        String s2 = this.name();
        for (Map.Entry<String, String> en : this.getAdditionalHeaders().entrySet()) {
            s2 = s2 + String.format("[%s=%s]", en.getKey(), en.getValue());
        }
        return s2;
    }

    public int ordinal() {
        return this.ordinal;
    }

    public static final ConsistencyMode[] values() {
        ConsistencyMode[] res = new ConsistencyMode[]{DEFAULT, STALE, CONSISTENT};
        return res;
    }
}

