/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS.config;

import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.sun.jna.Library;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.sun.jna.Native;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.sun.jna.Pointer;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.sun.jna.Structure;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.sun.jna.WString;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.sun.jna.platform.win32.Guid;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.sun.jna.ptr.IntByReference;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.sun.jna.win32.W32APIOptions;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;

interface IPHlpAPI
extends Library {
    public static final IPHlpAPI INSTANCE = (IPHlpAPI)Native.load((String)"IPHlpAPI", IPHlpAPI.class, (Map)W32APIOptions.ASCII_OPTIONS);
    public static final int AF_UNSPEC = 0;
    public static final int AF_INET = 2;
    public static final int AF_INET6 = 23;
    public static final int GAA_FLAG_SKIP_UNICAST = 1;
    public static final int GAA_FLAG_SKIP_ANYCAST = 2;
    public static final int GAA_FLAG_SKIP_MULTICAST = 4;
    public static final int GAA_FLAG_SKIP_DNS_SERVER = 8;
    public static final int GAA_FLAG_INCLUDE_PREFIX = 16;
    public static final int GAA_FLAG_SKIP_FRIENDLY_NAME = 32;
    public static final int GAA_FLAG_INCLUDE_WINS_INFO = 64;
    public static final int GAA_FLAG_INCLUDE_GATEWAYS = 128;
    public static final int GAA_FLAG_INCLUDE_ALL_INTERFACES = 256;
    public static final int GAA_FLAG_INCLUDE_ALL_COMPARTMENTS = 512;
    public static final int GAA_FLAG_INCLUDE_TUNNEL_BINDINGORDER = 1024;

    public int GetAdaptersAddresses(int var1, int var2, Pointer var3, Pointer var4, IntByReference var5);

    @Structure.FieldOrder(value={"Length", "IfIndex", "Next", "AdapterName", "FirstUnicastAddress", "FirstAnycastAddress", "FirstMulticastAddress", "FirstDnsServerAddress", "DnsSuffix", "Description", "FriendlyName", "PhysicalAddress", "PhysicalAddressLength", "Flags", "Mtu", "IfType", "OperStatus", "Ipv6IfIndex", "ZoneIndices", "FirstPrefix", "TransmitLinkSpeed", "ReceiveLinkSpeed", "FirstWinsServerAddress", "FirstGatewayAddress", "Ipv4Metric", "Ipv6Metric", "Luid", "Dhcpv4Server", "CompartmentId", "NetworkGuid", "ConnectionType", "TunnelType", "Dhcpv6Server", "Dhcpv6ClientDuid", "Dhcpv6ClientDuidLength", "Dhcpv6Iaid", "FirstDnsSuffix"})
    public static class IP_ADAPTER_ADDRESSES_LH
    extends Structure {
        public int Length;
        public int IfIndex;
        public ByReference Next;
        public String AdapterName;
        public IP_ADAPTER_UNICAST_ADDRESS_LH.ByReference FirstUnicastAddress;
        public IP_ADAPTER_ANYCAST_ADDRESS_XP.ByReference FirstAnycastAddress;
        public IP_ADAPTER_MULTICAST_ADDRESS_XP.ByReference FirstMulticastAddress;
        public IP_ADAPTER_DNS_SERVER_ADDRESS_XP.ByReference FirstDnsServerAddress;
        public WString DnsSuffix;
        public WString Description;
        public WString FriendlyName;
        public byte[] PhysicalAddress = new byte[8];
        public int PhysicalAddressLength;
        public int Flags;
        public int Mtu;
        public int IfType;
        public int OperStatus;
        public int Ipv6IfIndex;
        public int[] ZoneIndices = new int[16];
        public Pointer FirstPrefix;
        public long TransmitLinkSpeed;
        public long ReceiveLinkSpeed;
        public Pointer FirstWinsServerAddress;
        public Pointer FirstGatewayAddress;
        public int Ipv4Metric;
        public int Ipv6Metric;
        public Pointer Luid;
        public SOCKET_ADDRESS Dhcpv4Server;
        public int CompartmentId;
        public Guid.GUID NetworkGuid;
        public int ConnectionType;
        public int TunnelType;
        public SOCKET_ADDRESS Dhcpv6Server;
        public byte[] Dhcpv6ClientDuid = new byte[130];
        public int Dhcpv6ClientDuidLength;
        public int Dhcpv6Iaid;
        public IP_ADAPTER_DNS_SUFFIX.ByReference FirstDnsSuffix;

        public IP_ADAPTER_ADDRESSES_LH(Pointer p) {
            super(p);
            this.read();
        }

        public IP_ADAPTER_ADDRESSES_LH() {
        }

        public static class ByReference
        extends IP_ADAPTER_ADDRESSES_LH
        implements Structure.ByReference {
        }
    }

    @Structure.FieldOrder(value={"Next", "_String"})
    public static class IP_ADAPTER_DNS_SUFFIX
    extends Structure {
        public ByReference Next;
        public char[] _String = new char[256];

        public static class ByReference
        extends IP_ADAPTER_DNS_SUFFIX
        implements Structure.ByReference {
        }
    }

    @Structure.FieldOrder(value={"Length", "Reserved", "Next", "Address"})
    public static class IP_ADAPTER_MULTICAST_ADDRESS_XP
    extends Structure {
        public int Length;
        public int Reserved;
        public IP_ADAPTER_DNS_SERVER_ADDRESS_XP.ByReference Next;
        public SOCKET_ADDRESS Address;

        public static class ByReference
        extends IP_ADAPTER_MULTICAST_ADDRESS_XP
        implements Structure.ByReference {
        }
    }

    @Structure.FieldOrder(value={"Length", "Reserved", "Next", "Address"})
    public static class IP_ADAPTER_ANYCAST_ADDRESS_XP
    extends Structure {
        public int Length;
        public int Reserved;
        public IP_ADAPTER_DNS_SERVER_ADDRESS_XP.ByReference Next;
        public SOCKET_ADDRESS Address;

        public static class ByReference
        extends IP_ADAPTER_ANYCAST_ADDRESS_XP
        implements Structure.ByReference {
        }
    }

    @Structure.FieldOrder(value={"Length", "Reserved", "Next", "Address"})
    public static class IP_ADAPTER_DNS_SERVER_ADDRESS_XP
    extends Structure {
        public int Length;
        public int Reserved;
        public ByReference Next;
        public SOCKET_ADDRESS Address;

        public static class ByReference
        extends IP_ADAPTER_DNS_SERVER_ADDRESS_XP
        implements Structure.ByReference {
        }
    }

    @Structure.FieldOrder(value={"Length", "IfIndex", "Next", "Address", "PrefixOrigin", "SuffixOrigin", "DadState", "ValidLifetime", "PreferredLifetime", "LeaseLifetime", "OnLinkPrefixLength"})
    public static class IP_ADAPTER_UNICAST_ADDRESS_LH
    extends Structure {
        public int Length;
        public int IfIndex;
        public ByReference Next;
        public SOCKET_ADDRESS Address;
        public int PrefixOrigin;
        public int SuffixOrigin;
        public int DadState;
        public int ValidLifetime;
        public int PreferredLifetime;
        public int LeaseLifetime;
        public byte OnLinkPrefixLength;

        public static class ByReference
        extends IP_ADAPTER_UNICAST_ADDRESS_LH
        implements Structure.ByReference {
        }
    }

    @Structure.FieldOrder(value={"lpSockaddr", "iSockaddrLength"})
    public static class SOCKET_ADDRESS
    extends Structure {
        public Pointer lpSockaddr;
        public int iSockaddrLength;

        InetAddress toAddress() throws UnknownHostException {
            switch (this.lpSockaddr.getShort(0L)) {
                case 2: {
                    sockaddr_in in4 = new sockaddr_in(this.lpSockaddr);
                    return InetAddress.getByAddress(in4.sin_addr);
                }
                case 23: {
                    sockaddr_in6 in6 = new sockaddr_in6(this.lpSockaddr);
                    return Inet6Address.getByAddress("", in6.sin6_addr, in6.sin6_scope_id);
                }
            }
            return null;
        }
    }

    @Structure.FieldOrder(value={"sin6_family", "sin6_port", "sin6_flowinfo", "sin6_addr", "sin6_scope_id"})
    public static class sockaddr_in6
    extends Structure {
        public short sin6_family;
        public short sin6_port;
        public int sin6_flowinfo;
        public byte[] sin6_addr = new byte[16];
        public int sin6_scope_id;

        public sockaddr_in6(Pointer p) {
            super(p);
            this.read();
        }
    }

    @Structure.FieldOrder(value={"sin_family", "sin_port", "sin_addr", "sin_zero"})
    public static class sockaddr_in
    extends Structure {
        public short sin_family;
        public short sin_port;
        public byte[] sin_addr = new byte[4];
        public byte[] sin_zero = new byte[8];

        public sockaddr_in(Pointer p) {
            super(p);
            this.read();
        }
    }
}

