/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.io.hops.transaction.handler;

import io.hops.hadoop.shaded.io.hops.exception.TransientStorageException;
import io.hops.hadoop.shaded.io.hops.log.NDCWrapper;
import io.hops.hadoop.shaded.io.hops.transaction.handler.RequestHandler;
import java.io.IOException;

public abstract class LightWeightRequestHandler
extends RequestHandler {
    public LightWeightRequestHandler(RequestHandler.OperationType opType) {
        super(opType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object execute(Object info) throws IOException {
        int tryCount = 0;
        long totalTime = 0L;
        while (tryCount <= RETRY_COUNT) {
            boolean commited = false;
            boolean newTransaction = true;
            boolean returnSession = false;
            this.exponentialBackoff();
            ++tryCount;
            try {
                NDCWrapper.push(this.opType.toString());
                if (connector.isTransactionActive()) {
                    newTransaction = false;
                }
                connector.readCommitted();
                totalTime = System.currentTimeMillis();
                Object ret = this.performTask();
                commited = true;
                returnSession = true;
                totalTime = System.currentTimeMillis() - totalTime;
                if (requestHandlerLOG.isTraceEnabled()) {
                    requestHandlerLOG.trace((Object)(this.opType + " TX Finished. Total time taken. Time " + totalTime + " ms"));
                }
                Object object = ret;
                return object;
            }
            catch (Throwable t) {
                if (!commited) {
                    totalTime = System.currentTimeMillis() - totalTime;
                }
                String msgPrepend = !NDCWrapper.NDCEnabled() ? this.opType + " " : "";
                requestHandlerLOG.error((Object)(msgPrepend + "Tx Failed. total tx time  TotalRetryCount(" + RETRY_COUNT + ") RemainingRetries(" + (RETRY_COUNT - tryCount) + ") TX Stats: ms, Total Time: " + totalTime + "ms"), t);
                if (t instanceof TransientStorageException && tryCount <= RETRY_COUNT && newTransaction) continue;
                returnSession = true;
                throw t;
            }
            finally {
                if (!commited && connector.isTransactionActive() && newTransaction) {
                    if (requestHandlerLOG.isTraceEnabled()) {
                        requestHandlerLOG.trace((Object)("Transaction rollback. retries:" + RETRY_COUNT));
                    }
                    connector.rollback();
                }
                if (newTransaction && returnSession) {
                    connector.returnSession(false);
                }
                NDCWrapper.pop();
                if (!NDCWrapper.peek().equals("")) continue;
                NDCWrapper.remove();
            }
        }
        throw new RuntimeException("LightWeightRequestHandler did not execute");
    }
}

