/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.jaas;

import io.hops.hadoop.shaded.org.apache.commons.io.output.FileWriterWithEncoding;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.KrbException;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenCache {
    private static final Logger LOG = LoggerFactory.getLogger(TokenCache.class);
    private static final String DEFAULT_TOKEN_CACHE_PATH = ".tokenauth";
    private static final String TOKEN_CACHE_FILE = ".tokenauth.token";

    public static String readToken(String tokenCacheFile) {
        File cacheFile;
        if (tokenCacheFile != null && !tokenCacheFile.isEmpty()) {
            cacheFile = new File(tokenCacheFile);
            if (!cacheFile.exists()) {
                throw new RuntimeException("Invalid token cache specified: " + tokenCacheFile);
            }
        } else {
            cacheFile = TokenCache.getDefaultTokenCache();
            if (!cacheFile.exists()) {
                throw new RuntimeException("No token cache available by default");
            }
        }
        String token = null;
        try {
            List<String> lines = Files.readAllLines(cacheFile.toPath(), StandardCharsets.UTF_8);
            if (lines != null && !lines.isEmpty()) {
                token = lines.get(0);
            }
        }
        catch (IOException ex) {
            LOG.error("Failed to read file: " + cacheFile.getName());
        }
        return token;
    }

    public static void writeToken(String token, String tokenCacheFile) {
        File cacheFile = new File(tokenCacheFile);
        try {
            FileWriterWithEncoding writer = new FileWriterWithEncoding(cacheFile, StandardCharsets.UTF_8);
            ((Writer)writer).write(token);
            ((Writer)writer).flush();
            ((Writer)writer).close();
            cacheFile.setReadable(false, false);
            cacheFile.setReadable(true, true);
            if (!cacheFile.setWritable(true, true)) {
                throw new KrbException("Cache file is not readable.");
            }
        }
        catch (IOException ioe) {
            if (cacheFile.delete()) {
                System.err.println("Cache file is deleted.");
            }
        }
        catch (KrbException e) {
            LOG.error("Failed to write token to cache File. " + e.toString());
        }
    }

    public static File getDefaultTokenCache() {
        String homeDir = System.getProperty("user.home", DEFAULT_TOKEN_CACHE_PATH);
        return new File(homeDir, TOKEN_CACHE_FILE);
    }
}

