/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.crypto.dh;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class OctetString2Key {
    public static byte[] kTruncate(int k, byte[] x) {
        int numberOfBytes = k / 8;
        byte[] result = new byte[numberOfBytes];
        int count = 0;
        byte[] filler = OctetString2Key.calculateIntegrity((byte)count, x);
        int position = 0;
        for (int i = 0; i < numberOfBytes; ++i) {
            if (position < filler.length) {
                result[i] = filler[position];
                ++position;
                continue;
            }
            filler = OctetString2Key.calculateIntegrity((byte)(++count), x);
            position = 0;
            result[i] = filler[position];
            ++position;
        }
        return result;
    }

    private static byte[] calculateIntegrity(byte count, byte[] data) {
        try {
            MessageDigest digester = MessageDigest.getInstance("SHA1");
            digester.update(count);
            return digester.digest(data);
        }
        catch (NoSuchAlgorithmException nsae) {
            return new byte[0];
        }
    }
}

