/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.io.hops.metadata.hdfs.entity;

import io.hops.hadoop.shaded.io.hops.metadata.common.FinderType;
import java.util.Arrays;
import java.util.Objects;

public class RetryCacheEntry {
    public static byte SUCCESS = 1;
    public static byte FAILED = (byte)-1;
    private byte[] clientId;
    private int callId;
    private byte[] payload;
    private long expirationTime;
    private long epoch;
    private byte state;

    public RetryCacheEntry(byte[] clientId, int callId, long epoch) {
        this.clientId = clientId;
        this.callId = callId;
        this.payload = null;
        this.expirationTime = 0L;
        this.state = 0;
        this.epoch = epoch;
    }

    public RetryCacheEntry(byte[] clientId, int callId, byte[] payload, long expirationTime, long epoch, byte state) {
        this.clientId = clientId;
        this.callId = callId;
        this.payload = payload;
        this.expirationTime = expirationTime;
        this.epoch = epoch;
        this.state = state;
    }

    public byte[] getClientId() {
        return this.clientId;
    }

    public int getCallId() {
        return this.callId;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    public void setExpirationTime(long expirationTime) {
        this.expirationTime = expirationTime;
    }

    public long getEpoch() {
        return this.epoch;
    }

    public void setEpoch(long epoch) {
        this.epoch = epoch;
    }

    public byte getState() {
        return this.state;
    }

    public String toString() {
        return "RetryCacheEntry{clientId=" + Arrays.toString(this.clientId) + ", callId=" + this.callId + ", payload=" + Arrays.toString(this.payload) + ", expirationTime=" + this.expirationTime + ", epoch=" + this.epoch + ", state=" + this.state + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RetryCacheEntry that = (RetryCacheEntry)o;
        return this.callId == that.callId && this.epoch == that.epoch && Arrays.equals(this.clientId, that.clientId);
    }

    public int hashCode() {
        int result = Objects.hash(this.callId, this.epoch);
        result = 31 * result + Arrays.hashCode(this.clientId);
        return result;
    }

    public boolean isSuccess() {
        return this.getState() == SUCCESS;
    }

    public static class PrimaryKey {
        private byte[] clientId;
        private int callId;
        private long epoch;

        public PrimaryKey(byte[] clientId, int callId, long epoch) {
            this.clientId = clientId;
            this.callId = callId;
            this.epoch = epoch;
        }

        public byte[] getClientId() {
            return this.clientId;
        }

        public int getCallId() {
            return this.callId;
        }

        public long getEpoch() {
            return this.epoch;
        }

        public boolean equals(Object o) {
            if (o instanceof PrimaryKey) {
                PrimaryKey otherPK = (PrimaryKey)o;
                return this.clientId == otherPK.getClientId() && this.callId == otherPK.getCallId() && this.epoch == otherPK.epoch;
            }
            return false;
        }

        public int hashCode() {
            return Arrays.hashCode(this.clientId) + Integer.hashCode(this.callId) + Long.hashCode(this.epoch);
        }
    }

    public static enum Finder implements FinderType<RetryCacheEntry>
    {
        ByPK;


        @Override
        public Class getType() {
            return RetryCacheEntry.class;
        }

        @Override
        public FinderType.Annotation getAnnotated() {
            switch (this) {
                case ByPK: {
                    return FinderType.Annotation.PrimaryKey;
                }
            }
            throw new IllegalStateException();
        }
    }
}

