/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.net.minidev.json.reader;

import io.hops.hadoop.shaded.net.minidev.asm.Accessor;
import io.hops.hadoop.shaded.net.minidev.asm.BeansAccess;
import io.hops.hadoop.shaded.net.minidev.json.JSONObject;
import io.hops.hadoop.shaded.net.minidev.json.JSONStyle;
import io.hops.hadoop.shaded.net.minidev.json.JSONUtil;
import io.hops.hadoop.shaded.net.minidev.json.reader.JsonWriterI;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class BeansWriterASMRemap
implements JsonWriterI<Object> {
    private Map<String, String> rename = new HashMap<String, String>();

    public void renameField(String source, String dest) {
        this.rename.put(source, dest);
    }

    private String rename(String key) {
        String k2 = this.rename.get(key);
        if (k2 != null) {
            return k2;
        }
        return key;
    }

    @Override
    public <E> void writeJSONString(E value, Appendable out, JSONStyle compression) throws IOException {
        Class<?> cls = value.getClass();
        boolean needSep = false;
        BeansAccess<?> fields = BeansAccess.get(cls, JSONUtil.JSON_SMART_FIELD_FILTER);
        out.append('{');
        Accessor[] accessorArray = fields.getAccessors();
        int n = accessorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Accessor field = accessorArray[n2];
            Object v = fields.get(value, field.getIndex());
            if (v != null || !compression.ignoreNull()) {
                if (needSep) {
                    out.append(',');
                } else {
                    needSep = true;
                }
                String key = field.getName();
                key = this.rename(key);
                JSONObject.writeJSONKV(key, v, out, compression);
            }
            ++n2;
        }
        out.append('}');
    }
}

