/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.commons.math3.optim;

import io.hops.hadoop.shaded.org.apache.commons.math3.exception.DimensionMismatchException;
import io.hops.hadoop.shaded.org.apache.commons.math3.exception.NumberIsTooLargeException;
import io.hops.hadoop.shaded.org.apache.commons.math3.exception.NumberIsTooSmallException;
import io.hops.hadoop.shaded.org.apache.commons.math3.optim.BaseOptimizer;
import io.hops.hadoop.shaded.org.apache.commons.math3.optim.ConvergenceChecker;
import io.hops.hadoop.shaded.org.apache.commons.math3.optim.InitialGuess;
import io.hops.hadoop.shaded.org.apache.commons.math3.optim.OptimizationData;
import io.hops.hadoop.shaded.org.apache.commons.math3.optim.SimpleBounds;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseMultivariateOptimizer<PAIR>
extends BaseOptimizer<PAIR> {
    private double[] start;
    private double[] lowerBound;
    private double[] upperBound;

    protected BaseMultivariateOptimizer(ConvergenceChecker<PAIR> checker) {
        super(checker);
    }

    @Override
    public PAIR optimize(OptimizationData ... optData) {
        this.parseOptimizationData(optData);
        this.checkParameters();
        return super.optimize(optData);
    }

    private void parseOptimizationData(OptimizationData ... optData) {
        for (OptimizationData data : optData) {
            if (data instanceof InitialGuess) {
                this.start = ((InitialGuess)data).getInitialGuess();
                continue;
            }
            if (!(data instanceof SimpleBounds)) continue;
            SimpleBounds bounds = (SimpleBounds)data;
            this.lowerBound = bounds.getLower();
            this.upperBound = bounds.getUpper();
        }
    }

    public double[] getStartPoint() {
        return this.start == null ? null : (double[])this.start.clone();
    }

    public double[] getLowerBound() {
        return this.lowerBound == null ? null : (double[])this.lowerBound.clone();
    }

    public double[] getUpperBound() {
        return this.upperBound == null ? null : (double[])this.upperBound.clone();
    }

    private void checkParameters() {
        if (this.start != null) {
            double v;
            int i;
            int dim = this.start.length;
            if (this.lowerBound != null) {
                if (this.lowerBound.length != dim) {
                    throw new DimensionMismatchException(this.lowerBound.length, dim);
                }
                for (i = 0; i < dim; ++i) {
                    v = this.start[i];
                    double lo = this.lowerBound[i];
                    if (!(v < lo)) continue;
                    throw new NumberIsTooSmallException(v, (Number)lo, true);
                }
            }
            if (this.upperBound != null) {
                if (this.upperBound.length != dim) {
                    throw new DimensionMismatchException(this.upperBound.length, dim);
                }
                for (i = 0; i < dim; ++i) {
                    v = this.start[i];
                    double hi = this.upperBound[i];
                    if (!(v > hi)) continue;
                    throw new NumberIsTooLargeException(v, (Number)hi, true);
                }
            }
        }
    }
}

