/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.commons.math3.optim.nonlinear.vector.jacobian;

import io.hops.hadoop.shaded.org.apache.commons.math3.exception.DimensionMismatchException;
import io.hops.hadoop.shaded.org.apache.commons.math3.exception.TooManyEvaluationsException;
import io.hops.hadoop.shaded.org.apache.commons.math3.linear.ArrayRealVector;
import io.hops.hadoop.shaded.org.apache.commons.math3.linear.DecompositionSolver;
import io.hops.hadoop.shaded.org.apache.commons.math3.linear.DiagonalMatrix;
import io.hops.hadoop.shaded.org.apache.commons.math3.linear.EigenDecomposition;
import io.hops.hadoop.shaded.org.apache.commons.math3.linear.MatrixUtils;
import io.hops.hadoop.shaded.org.apache.commons.math3.linear.QRDecomposition;
import io.hops.hadoop.shaded.org.apache.commons.math3.linear.RealMatrix;
import io.hops.hadoop.shaded.org.apache.commons.math3.optim.ConvergenceChecker;
import io.hops.hadoop.shaded.org.apache.commons.math3.optim.OptimizationData;
import io.hops.hadoop.shaded.org.apache.commons.math3.optim.PointVectorValuePair;
import io.hops.hadoop.shaded.org.apache.commons.math3.optim.nonlinear.vector.JacobianMultivariateVectorOptimizer;
import io.hops.hadoop.shaded.org.apache.commons.math3.optim.nonlinear.vector.Weight;
import io.hops.hadoop.shaded.org.apache.commons.math3.util.FastMath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLeastSquaresOptimizer
extends JacobianMultivariateVectorOptimizer {
    private RealMatrix weightMatrixSqrt;
    private double cost;

    protected AbstractLeastSquaresOptimizer(ConvergenceChecker<PointVectorValuePair> checker) {
        super(checker);
    }

    protected RealMatrix computeWeightedJacobian(double[] params) {
        return this.weightMatrixSqrt.multiply(MatrixUtils.createRealMatrix(this.computeJacobian(params)));
    }

    protected double computeCost(double[] residuals) {
        ArrayRealVector r = new ArrayRealVector(residuals);
        return FastMath.sqrt(r.dotProduct(this.getWeight().operate(r)));
    }

    public double getRMS() {
        return FastMath.sqrt(this.getChiSquare() / (double)this.getTargetSize());
    }

    public double getChiSquare() {
        return this.cost * this.cost;
    }

    public RealMatrix getWeightSquareRoot() {
        return this.weightMatrixSqrt.copy();
    }

    protected void setCost(double cost) {
        this.cost = cost;
    }

    public double[][] computeCovariances(double[] params, double threshold) {
        RealMatrix j = this.computeWeightedJacobian(params);
        RealMatrix jTj = j.transpose().multiply(j);
        DecompositionSolver solver = new QRDecomposition(jTj, threshold).getSolver();
        return solver.getInverse().getData();
    }

    public double[] computeSigma(double[] params, double covarianceSingularityThreshold) {
        int nC = params.length;
        double[] sig = new double[nC];
        double[][] cov = this.computeCovariances(params, covarianceSingularityThreshold);
        for (int i = 0; i < nC; ++i) {
            sig[i] = FastMath.sqrt(cov[i][i]);
        }
        return sig;
    }

    @Override
    public PointVectorValuePair optimize(OptimizationData ... optData) throws TooManyEvaluationsException {
        this.parseOptimizationData(optData);
        return super.optimize(optData);
    }

    protected double[] computeResiduals(double[] objectiveValue) {
        double[] target = this.getTarget();
        if (objectiveValue.length != target.length) {
            throw new DimensionMismatchException(target.length, objectiveValue.length);
        }
        double[] residuals = new double[target.length];
        for (int i = 0; i < target.length; ++i) {
            residuals[i] = target[i] - objectiveValue[i];
        }
        return residuals;
    }

    private void parseOptimizationData(OptimizationData ... optData) {
        for (OptimizationData data : optData) {
            if (!(data instanceof Weight)) continue;
            this.weightMatrixSqrt = this.squareRoot(((Weight)data).getWeight());
            break;
        }
    }

    private RealMatrix squareRoot(RealMatrix m3) {
        if (m3 instanceof DiagonalMatrix) {
            int dim = m3.getRowDimension();
            DiagonalMatrix sqrtM = new DiagonalMatrix(dim);
            for (int i = 0; i < dim; ++i) {
                sqrtM.setEntry(i, i, FastMath.sqrt(m3.getEntry(i, i)));
            }
            return sqrtM;
        }
        EigenDecomposition dec = new EigenDecomposition(m3);
        return dec.getSquareRoot();
    }
}

