/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS;

import io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS.Compression;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS.DNSInput;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS.DNSOutput;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS.Name;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS.Options;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS.Record;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS.Tokenizer;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS.utils.base64;
import java.io.IOException;

public class OPENPGPKEYRecord
extends Record {
    private byte[] cert;

    OPENPGPKEYRecord() {
    }

    public OPENPGPKEYRecord(Name name, int dclass, long ttl, byte[] cert) {
        super(name, 61, dclass, ttl);
        this.cert = cert;
    }

    @Override
    void rrFromWire(DNSInput in) {
        this.cert = in.readByteArray();
    }

    @Override
    void rdataFromString(Tokenizer st, Name origin) throws IOException {
        this.cert = st.getBase64();
    }

    @Override
    String rrToString() {
        StringBuilder sb = new StringBuilder();
        if (this.cert != null) {
            if (Options.check("multiline")) {
                sb.append("(\n");
                sb.append(base64.formatString(this.cert, 64, "\t", true));
            } else {
                sb.append(base64.toString(this.cert));
            }
        }
        return sb.toString();
    }

    public byte[] getCert() {
        return this.cert;
    }

    @Override
    void rrToWire(DNSOutput out, Compression c, boolean canonical) {
        out.writeByteArray(this.cert);
    }
}

