/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.com.nimbusds.jose;

import io.hops.hadoop.shaded.com.nimbusds.jose.Requirement;
import io.hops.hadoop.shaded.net.jcip.annotations.Immutable;
import io.hops.hadoop.shaded.net.minidev.json.JSONAware;
import io.hops.hadoop.shaded.net.minidev.json.JSONObject;
import java.io.Serializable;

@Immutable
public class Algorithm
implements JSONAware,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final Algorithm NONE = new Algorithm("none", Requirement.REQUIRED);
    private final String name;
    private final Requirement requirement;

    public Algorithm(String name, Requirement req) {
        if (name == null) {
            throw new IllegalArgumentException("The algorithm name must not be null");
        }
        this.name = name;
        this.requirement = req;
    }

    public Algorithm(String name) {
        this(name, null);
    }

    public final String getName() {
        return this.name;
    }

    public final Requirement getRequirement() {
        return this.requirement;
    }

    public final int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object object) {
        return object != null && object instanceof Algorithm && this.toString().equals(object.toString());
    }

    public final String toString() {
        return this.name;
    }

    @Override
    public final String toJSONString() {
        return "\"" + JSONObject.escape(this.name) + '\"';
    }
}

