/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.kerby.asn1;

import io.hops.hadoop.shaded.org.apache.kerby.asn1.Tag;
import io.hops.hadoop.shaded.org.apache.kerby.asn1.TagClass;

public final class TaggingOption {
    private int tagNo;
    private boolean isImplicit;
    private boolean isAppSpecific;

    public static TaggingOption newImplicitAppSpecific(int tagNo) {
        return new TaggingOption(tagNo, true, true);
    }

    public static TaggingOption newExplicitAppSpecific(int tagNo) {
        return new TaggingOption(tagNo, false, true);
    }

    public static TaggingOption newImplicitContextSpecific(int tagNo) {
        return new TaggingOption(tagNo, true, false);
    }

    public static TaggingOption newExplicitContextSpecific(int tagNo) {
        return new TaggingOption(tagNo, false, false);
    }

    private TaggingOption(int tagNo, boolean isImplicit, boolean isAppSpecific) {
        this.tagNo = tagNo;
        this.isImplicit = isImplicit;
        this.isAppSpecific = isAppSpecific;
    }

    public Tag getTag(boolean isTaggedConstructed) {
        boolean isConstructed = !this.isImplicit || isTaggedConstructed;
        TagClass tagClass = this.isAppSpecific ? TagClass.APPLICATION : TagClass.CONTEXT_SPECIFIC;
        int flags = tagClass.getValue() | (isConstructed ? 32 : 0);
        return new Tag(flags, this.tagNo);
    }

    public int getTagNo() {
        return this.tagNo;
    }

    public boolean isAppSpecific() {
        return this.isAppSpecific;
    }

    public boolean isImplicit() {
        return this.isImplicit;
    }
}

