/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul.model.agent;

import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.google.common.base.MoreObjects;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.google.common.collect.ImmutableList;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.google.common.collect.ImmutableMap;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul.model.agent.FullService;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul.model.agent.ServiceProxy;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul.model.catalog.ServiceWeights;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.org.immutables.value.Generated;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="FullService", generator="Immutables")
@Immutable
public final class ImmutableFullService
extends FullService {
    @Nullable
    private final String kind;
    private final String id;
    private final String service;
    private final ImmutableList<String> tags;
    private final ImmutableMap<String, String> meta;
    private final int port;
    private final String address;
    @Nullable
    private final ServiceWeights weights;
    @Nullable
    private final Boolean enableTagOverride;
    private final String contentHash;
    @Nullable
    private final ServiceProxy proxy;

    private ImmutableFullService(@Nullable String kind, String id, String service, ImmutableList<String> tags, ImmutableMap<String, String> meta, int port, String address, @Nullable ServiceWeights weights, @Nullable Boolean enableTagOverride, String contentHash, @Nullable ServiceProxy proxy) {
        this.kind = kind;
        this.id = id;
        this.service = service;
        this.tags = tags;
        this.meta = meta;
        this.port = port;
        this.address = address;
        this.weights = weights;
        this.enableTagOverride = enableTagOverride;
        this.contentHash = contentHash;
        this.proxy = proxy;
    }

    @Override
    @JsonProperty(value="Kind")
    public Optional<String> getKind() {
        return Optional.ofNullable(this.kind);
    }

    @Override
    @JsonProperty(value="ID")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="Service")
    public String getService() {
        return this.service;
    }

    @JsonProperty(value="Tags")
    @JsonDeserialize(as=ImmutableList.class, contentAs=String.class)
    public ImmutableList<String> getTags() {
        return this.tags;
    }

    @JsonProperty(value="Meta")
    public ImmutableMap<String, String> getMeta() {
        return this.meta;
    }

    @Override
    @JsonProperty(value="Port")
    public int getPort() {
        return this.port;
    }

    @Override
    @JsonProperty(value="Address")
    public String getAddress() {
        return this.address;
    }

    @Override
    @JsonProperty(value="Weights")
    public Optional<ServiceWeights> getWeights() {
        return Optional.ofNullable(this.weights);
    }

    @Override
    @JsonProperty(value="EnableTagOverride")
    public Optional<Boolean> getEnableTagOverride() {
        return Optional.ofNullable(this.enableTagOverride);
    }

    @Override
    @JsonProperty(value="ContentHash")
    public String getContentHash() {
        return this.contentHash;
    }

    @Override
    @JsonProperty(value="Proxy")
    public Optional<ServiceProxy> getProxy() {
        return Optional.ofNullable(this.proxy);
    }

    public final ImmutableFullService withKind(String value) {
        String newValue = Objects.requireNonNull(value, "kind");
        if (Objects.equals(this.kind, newValue)) {
            return this;
        }
        return new ImmutableFullService(newValue, this.id, this.service, this.tags, this.meta, this.port, this.address, this.weights, this.enableTagOverride, this.contentHash, this.proxy);
    }

    public final ImmutableFullService withKind(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.kind, value)) {
            return this;
        }
        return new ImmutableFullService(value, this.id, this.service, this.tags, this.meta, this.port, this.address, this.weights, this.enableTagOverride, this.contentHash, this.proxy);
    }

    public final ImmutableFullService withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableFullService(this.kind, newValue, this.service, this.tags, this.meta, this.port, this.address, this.weights, this.enableTagOverride, this.contentHash, this.proxy);
    }

    public final ImmutableFullService withService(String value) {
        String newValue = Objects.requireNonNull(value, "service");
        if (this.service.equals(newValue)) {
            return this;
        }
        return new ImmutableFullService(this.kind, this.id, newValue, this.tags, this.meta, this.port, this.address, this.weights, this.enableTagOverride, this.contentHash, this.proxy);
    }

    public final ImmutableFullService withTags(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableFullService(this.kind, this.id, this.service, newValue, this.meta, this.port, this.address, this.weights, this.enableTagOverride, this.contentHash, this.proxy);
    }

    public final ImmutableFullService withTags(Iterable<String> elements) {
        if (this.tags == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableFullService(this.kind, this.id, this.service, newValue, this.meta, this.port, this.address, this.weights, this.enableTagOverride, this.contentHash, this.proxy);
    }

    public final ImmutableFullService withMeta(Map<String, ? extends String> entries) {
        if (this.meta == entries) {
            return this;
        }
        ImmutableMap<String, String> newValue = ImmutableMap.copyOf(entries);
        return new ImmutableFullService(this.kind, this.id, this.service, this.tags, newValue, this.port, this.address, this.weights, this.enableTagOverride, this.contentHash, this.proxy);
    }

    public final ImmutableFullService withPort(int value) {
        if (this.port == value) {
            return this;
        }
        return new ImmutableFullService(this.kind, this.id, this.service, this.tags, this.meta, value, this.address, this.weights, this.enableTagOverride, this.contentHash, this.proxy);
    }

    public final ImmutableFullService withAddress(String value) {
        String newValue = Objects.requireNonNull(value, "address");
        if (this.address.equals(newValue)) {
            return this;
        }
        return new ImmutableFullService(this.kind, this.id, this.service, this.tags, this.meta, this.port, newValue, this.weights, this.enableTagOverride, this.contentHash, this.proxy);
    }

    public final ImmutableFullService withWeights(ServiceWeights value) {
        ServiceWeights newValue = Objects.requireNonNull(value, "weights");
        if (this.weights == newValue) {
            return this;
        }
        return new ImmutableFullService(this.kind, this.id, this.service, this.tags, this.meta, this.port, this.address, newValue, this.enableTagOverride, this.contentHash, this.proxy);
    }

    public final ImmutableFullService withWeights(Optional<? extends ServiceWeights> optional) {
        ServiceWeights value = optional.orElse(null);
        if (this.weights == value) {
            return this;
        }
        return new ImmutableFullService(this.kind, this.id, this.service, this.tags, this.meta, this.port, this.address, value, this.enableTagOverride, this.contentHash, this.proxy);
    }

    public final ImmutableFullService withEnableTagOverride(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.enableTagOverride, newValue)) {
            return this;
        }
        return new ImmutableFullService(this.kind, this.id, this.service, this.tags, this.meta, this.port, this.address, this.weights, newValue, this.contentHash, this.proxy);
    }

    public final ImmutableFullService withEnableTagOverride(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.enableTagOverride, value)) {
            return this;
        }
        return new ImmutableFullService(this.kind, this.id, this.service, this.tags, this.meta, this.port, this.address, this.weights, value, this.contentHash, this.proxy);
    }

    public final ImmutableFullService withContentHash(String value) {
        String newValue = Objects.requireNonNull(value, "contentHash");
        if (this.contentHash.equals(newValue)) {
            return this;
        }
        return new ImmutableFullService(this.kind, this.id, this.service, this.tags, this.meta, this.port, this.address, this.weights, this.enableTagOverride, newValue, this.proxy);
    }

    public final ImmutableFullService withProxy(ServiceProxy value) {
        ServiceProxy newValue = Objects.requireNonNull(value, "proxy");
        if (this.proxy == newValue) {
            return this;
        }
        return new ImmutableFullService(this.kind, this.id, this.service, this.tags, this.meta, this.port, this.address, this.weights, this.enableTagOverride, this.contentHash, newValue);
    }

    public final ImmutableFullService withProxy(Optional<? extends ServiceProxy> optional) {
        ServiceProxy value = optional.orElse(null);
        if (this.proxy == value) {
            return this;
        }
        return new ImmutableFullService(this.kind, this.id, this.service, this.tags, this.meta, this.port, this.address, this.weights, this.enableTagOverride, this.contentHash, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFullService && this.equalTo((ImmutableFullService)another);
    }

    private boolean equalTo(ImmutableFullService another) {
        return Objects.equals(this.kind, another.kind) && this.id.equals(another.id) && this.service.equals(another.service) && this.tags.equals(another.tags) && this.meta.equals(another.meta) && this.port == another.port && this.address.equals(another.address) && Objects.equals(this.weights, another.weights) && Objects.equals(this.enableTagOverride, another.enableTagOverride) && this.contentHash.equals(another.contentHash) && Objects.equals(this.proxy, another.proxy);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.kind);
        h2 += (h2 << 5) + this.id.hashCode();
        h2 += (h2 << 5) + this.service.hashCode();
        h2 += (h2 << 5) + this.tags.hashCode();
        h2 += (h2 << 5) + this.meta.hashCode();
        h2 += (h2 << 5) + this.port;
        h2 += (h2 << 5) + this.address.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.weights);
        h2 += (h2 << 5) + Objects.hashCode(this.enableTagOverride);
        h2 += (h2 << 5) + this.contentHash.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.proxy);
        return h2;
    }

    public String toString() {
        return MoreObjects.toStringHelper("FullService").omitNullValues().add("kind", this.kind).add("id", this.id).add("service", this.service).add("tags", this.tags).add("meta", this.meta).add("port", this.port).add("address", this.address).add("weights", this.weights).add("enableTagOverride", this.enableTagOverride).add("contentHash", this.contentHash).add("proxy", this.proxy).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableFullService fromJson(Json json) {
        Builder builder = ImmutableFullService.builder();
        if (json.kind != null) {
            builder.kind(json.kind);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.service != null) {
            builder.service(json.service);
        }
        if (json.tags != null) {
            builder.addAllTags(json.tags);
        }
        if (json.meta != null) {
            builder.putAllMeta(json.meta);
        }
        if (json.portIsSet) {
            builder.port(json.port);
        }
        if (json.address != null) {
            builder.address(json.address);
        }
        if (json.weights != null) {
            builder.weights(json.weights);
        }
        if (json.enableTagOverride != null) {
            builder.enableTagOverride(json.enableTagOverride);
        }
        if (json.contentHash != null) {
            builder.contentHash(json.contentHash);
        }
        if (json.proxy != null) {
            builder.proxy(json.proxy);
        }
        return builder.build();
    }

    public static ImmutableFullService copyOf(FullService instance) {
        if (instance instanceof ImmutableFullService) {
            return (ImmutableFullService)instance;
        }
        return ImmutableFullService.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="FullService", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_SERVICE = 2L;
        private static final long INIT_BIT_PORT = 4L;
        private static final long INIT_BIT_ADDRESS = 8L;
        private static final long INIT_BIT_CONTENT_HASH = 16L;
        private long initBits = 31L;
        @Nullable
        private String kind;
        @Nullable
        private String id;
        @Nullable
        private String service;
        private ImmutableList.Builder<String> tags = ImmutableList.builder();
        private ImmutableMap.Builder<String, String> meta = ImmutableMap.builder();
        private int port;
        @Nullable
        private String address;
        @Nullable
        private ServiceWeights weights;
        @Nullable
        private Boolean enableTagOverride;
        @Nullable
        private String contentHash;
        @Nullable
        private ServiceProxy proxy;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(FullService instance) {
            Optional<Boolean> enableTagOverrideOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<String> kindOptional = instance.getKind();
            if (kindOptional.isPresent()) {
                this.kind(kindOptional);
            }
            this.id(instance.getId());
            this.service(instance.getService());
            this.addAllTags(instance.getTags());
            this.putAllMeta(instance.getMeta());
            this.port(instance.getPort());
            this.address(instance.getAddress());
            Optional<ServiceWeights> weightsOptional = instance.getWeights();
            if (weightsOptional.isPresent()) {
                this.weights(weightsOptional);
            }
            if ((enableTagOverrideOptional = instance.getEnableTagOverride()).isPresent()) {
                this.enableTagOverride(enableTagOverrideOptional);
            }
            this.contentHash(instance.getContentHash());
            Optional<ServiceProxy> proxyOptional = instance.getProxy();
            if (proxyOptional.isPresent()) {
                this.proxy(proxyOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder kind(String kind) {
            this.kind = Objects.requireNonNull(kind, "kind");
            return this;
        }

        @JsonProperty(value="Kind")
        @CanIgnoreReturnValue
        public final Builder kind(Optional<String> kind) {
            this.kind = kind.orElse(null);
            return this;
        }

        @JsonProperty(value="ID")
        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="Service")
        @CanIgnoreReturnValue
        public final Builder service(String service) {
            this.service = Objects.requireNonNull(service, "service");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTags(String element) {
            this.tags.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTags(String ... elements) {
            this.tags.add(elements);
            return this;
        }

        @JsonProperty(value="Tags")
        @JsonDeserialize(as=ImmutableList.class, contentAs=String.class)
        @CanIgnoreReturnValue
        public final Builder tags(Iterable<String> elements) {
            this.tags = ImmutableList.builder();
            return this.addAllTags(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllTags(Iterable<String> elements) {
            this.tags.addAll((Iterable)elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putMeta(String key, String value) {
            this.meta.put(key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putMeta(Map.Entry<String, ? extends String> entry) {
            this.meta.put(entry);
            return this;
        }

        @JsonProperty(value="Meta")
        @CanIgnoreReturnValue
        public final Builder meta(Map<String, ? extends String> entries) {
            this.meta = ImmutableMap.builder();
            return this.putAllMeta(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllMeta(Map<String, ? extends String> entries) {
            this.meta.putAll(entries);
            return this;
        }

        @JsonProperty(value="Port")
        @CanIgnoreReturnValue
        public final Builder port(int port) {
            this.port = port;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="Address")
        @CanIgnoreReturnValue
        public final Builder address(String address) {
            this.address = Objects.requireNonNull(address, "address");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder weights(ServiceWeights weights) {
            this.weights = Objects.requireNonNull(weights, "weights");
            return this;
        }

        @JsonProperty(value="Weights")
        @CanIgnoreReturnValue
        public final Builder weights(Optional<? extends ServiceWeights> weights) {
            this.weights = weights.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder enableTagOverride(boolean enableTagOverride) {
            this.enableTagOverride = enableTagOverride;
            return this;
        }

        @JsonProperty(value="EnableTagOverride")
        @CanIgnoreReturnValue
        public final Builder enableTagOverride(Optional<Boolean> enableTagOverride) {
            this.enableTagOverride = enableTagOverride.orElse(null);
            return this;
        }

        @JsonProperty(value="ContentHash")
        @CanIgnoreReturnValue
        public final Builder contentHash(String contentHash) {
            this.contentHash = Objects.requireNonNull(contentHash, "contentHash");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder proxy(ServiceProxy proxy) {
            this.proxy = Objects.requireNonNull(proxy, "proxy");
            return this;
        }

        @JsonProperty(value="Proxy")
        @CanIgnoreReturnValue
        public final Builder proxy(Optional<? extends ServiceProxy> proxy) {
            this.proxy = proxy.orElse(null);
            return this;
        }

        public ImmutableFullService build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFullService(this.kind, this.id, this.service, (ImmutableList)this.tags.build(), this.meta.build(), this.port, this.address, this.weights, this.enableTagOverride, this.contentHash, this.proxy);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("service");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("port");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("address");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("contentHash");
            }
            return "Cannot build FullService, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="FullService", generator="Immutables")
    static final class Json
    extends FullService {
        @Nullable
        Optional<String> kind = Optional.empty();
        @Nullable
        String id;
        @Nullable
        String service;
        @Nullable
        List<String> tags = ImmutableList.of();
        @Nullable
        Map<String, String> meta = ImmutableMap.of();
        int port;
        boolean portIsSet;
        @Nullable
        String address;
        @Nullable
        Optional<ServiceWeights> weights = Optional.empty();
        @Nullable
        Optional<Boolean> enableTagOverride = Optional.empty();
        @Nullable
        String contentHash;
        @Nullable
        Optional<ServiceProxy> proxy = Optional.empty();

        Json() {
        }

        @JsonProperty(value="Kind")
        public void setKind(Optional<String> kind) {
            this.kind = kind;
        }

        @JsonProperty(value="ID")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="Service")
        public void setService(String service) {
            this.service = service;
        }

        @JsonProperty(value="Tags")
        @JsonDeserialize(as=ImmutableList.class, contentAs=String.class)
        public void setTags(List<String> tags) {
            this.tags = tags;
        }

        @JsonProperty(value="Meta")
        public void setMeta(Map<String, String> meta) {
            this.meta = meta;
        }

        @JsonProperty(value="Port")
        public void setPort(int port) {
            this.port = port;
            this.portIsSet = true;
        }

        @JsonProperty(value="Address")
        public void setAddress(String address) {
            this.address = address;
        }

        @JsonProperty(value="Weights")
        public void setWeights(Optional<ServiceWeights> weights) {
            this.weights = weights;
        }

        @JsonProperty(value="EnableTagOverride")
        public void setEnableTagOverride(Optional<Boolean> enableTagOverride) {
            this.enableTagOverride = enableTagOverride;
        }

        @JsonProperty(value="ContentHash")
        public void setContentHash(String contentHash) {
            this.contentHash = contentHash;
        }

        @JsonProperty(value="Proxy")
        public void setProxy(Optional<ServiceProxy> proxy) {
            this.proxy = proxy;
        }

        @Override
        public Optional<String> getKind() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getService() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getTags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, String> getMeta() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getPort() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getAddress() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ServiceWeights> getWeights() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> getEnableTagOverride() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getContentHash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ServiceProxy> getProxy() {
            throw new UnsupportedOperationException();
        }
    }
}

