/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS;

import io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS.PacketLogger;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS.utils.hexdump;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Client {
    private static final Logger log = LoggerFactory.getLogger(Client.class);
    private static PacketLogger packetLogger = null;
    private static volatile boolean run;
    private static Thread selectorThread;
    private static List<Runnable> timeoutTasks;
    static Selector selector;

    Client() {
    }

    static void start() throws IOException {
        if (run) {
            return;
        }
        log.debug("Starting dnsjava NIO selector thread");
        run = true;
        selector = Selector.open();
        selectorThread = new Thread(Client::runSelector);
        selectorThread.setDaemon(true);
        selectorThread.setName("dnsjava NIO selector");
        selectorThread.start();
    }

    protected static void close() throws Exception {
        if (!run) {
            return;
        }
        run = false;
        timeoutTasks.clear();
        selector.wakeup();
        selector.close();
        selectorThread.join();
    }

    private static void runSelector() {
        while (run) {
            try {
                if (selector.select(1000L) == 0) {
                    timeoutTasks.forEach(Runnable::run);
                }
                Client.processReadyKeys();
            }
            catch (IOException e) {
                log.error("A selection operation failed", (Throwable)e);
            }
        }
    }

    static void addSelectorTimeoutTask(Runnable r) {
        timeoutTasks.add(r);
    }

    private static void processReadyKeys() {
        Iterator<SelectionKey> it = selector.selectedKeys().iterator();
        while (it.hasNext()) {
            SelectionKey key = it.next();
            it.remove();
            KeyProcessor t = (KeyProcessor)key.attachment();
            t.processReadyKey(key);
        }
    }

    static void verboseLog(String prefix, SocketAddress local, SocketAddress remote, byte[] data) {
        if (log.isTraceEnabled()) {
            log.trace(hexdump.dump(prefix, data));
        }
        if (packetLogger != null) {
            packetLogger.log(prefix, local, remote, data);
        }
    }

    static void setPacketLogger(PacketLogger logger) {
        packetLogger = logger;
    }

    static {
        timeoutTasks = new CopyOnWriteArrayList<Runnable>();
    }

    static interface KeyProcessor {
        public void processReadyKey(SelectionKey var1);
    }
}

