/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.io.hops.metadata.common.entity;

import io.hops.hadoop.shaded.io.hops.metadata.common.entity.ByteArrayVariable;
import io.hops.hadoop.shaded.io.hops.metadata.common.entity.Variable;
import java.io.UnsupportedEncodingException;

public class StringVariable
extends ByteArrayVariable {
    private String value = null;

    public StringVariable(Variable.Finder type, String value) {
        this(type);
        if (value.length() > 255) {
            throw new IllegalArgumentException("string variables shouldn't exceed 255 bytes");
        }
        this.value = value;
    }

    public StringVariable(Variable.Finder type) {
        super(type);
    }

    public StringVariable(String value) {
        this(Variable.Finder.GenericString, value);
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(byte[] val) {
        super.setValue(val);
        this.value = StringVariable.getString(super.getByteArrayValue());
    }

    @Override
    public byte[] getBytes() {
        byte[] s2 = StringVariable.getByteArray(this.value);
        super.setByteArrayValue(s2);
        return super.getBytes();
    }

    @Override
    public int getLength() {
        if (this.value == null) {
            return -1;
        }
        return StringVariable.getByteArray(this.value).length + 1;
    }

    private static byte[] getByteArray(String val) {
        try {
            return val.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static String getString(byte[] val) {
        try {
            return new String(val, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String toString() {
        return this.value;
    }
}

