/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.io.hops.metadata.common.entity;

import io.hops.hadoop.shaded.io.hops.metadata.common.FinderType;
import io.hops.hadoop.shaded.io.hops.metadata.common.entity.ArrayVariable;
import io.hops.hadoop.shaded.io.hops.metadata.common.entity.ByteArrayVariable;
import io.hops.hadoop.shaded.io.hops.metadata.common.entity.DoubleVariable;
import io.hops.hadoop.shaded.io.hops.metadata.common.entity.IntVariable;
import io.hops.hadoop.shaded.io.hops.metadata.common.entity.LongVariable;
import io.hops.hadoop.shaded.io.hops.metadata.common.entity.StringVariable;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;

public abstract class Variable {
    protected static final EnumMap<Finder, byte[]> defaultValues = new EnumMap(Finder.class);
    private final Finder type;

    public static void registerVariableDefaultValue(Finder variable, byte[] defaultValue) {
        defaultValues.put(variable, defaultValue);
    }

    public Variable(Finder type) {
        this.type = type;
    }

    public abstract void setValue(byte[] var1);

    public abstract byte[] getBytes();

    public abstract Object getValue();

    public abstract int getLength();

    public Finder getType() {
        return this.type;
    }

    public static Variable getVariable(byte varType) {
        Finder type = Finder.getFinder(varType);
        return Variable.getVariable(type);
    }

    public static Variable getVariable(Finder varType) {
        switch (varType) {
            case GenericInteger: {
                return new IntVariable(varType);
            }
            case GenericLong: {
                return new LongVariable(varType);
            }
            case GenericString: {
                return new StringVariable(varType);
            }
            case GenericByteArray: {
                return new ByteArrayVariable(varType);
            }
            case GenericArray: {
                return new ArrayVariable(varType);
            }
            case BlockID: {
                return new LongVariable(varType);
            }
            case INodeID: {
                return new LongVariable(varType);
            }
            case QuotaUpdateID: {
                return new IntVariable(varType);
            }
            case ReplicationIndex: {
                return new ArrayVariable(varType);
            }
            case StorageInfo: {
                return new ArrayVariable(varType);
            }
            case BlockTokenKeys: {
                return new ArrayVariable(varType);
            }
            case BTCurrKey: 
            case BTNextKey: 
            case BTSimpleKey: {
                return new ByteArrayVariable(varType);
            }
            case SIdCounter: {
                return new IntVariable(varType);
            }
            case HdfsLeParams: 
            case YarnLeParams: {
                return new StringVariable(varType);
            }
            case MisReplicatedFilesIndex: {
                return new LongVariable(varType);
            }
            case SafeModeReached: {
                return new LongVariable(varType);
            }
            case BrLbMaxConcurrentBRs: {
                return new LongVariable(varType);
            }
            case RMStateStoreVersion: {
                return new ByteArrayVariable(varType);
            }
            case RMStateStoreEpoch: {
                return new LongVariable(varType);
            }
            case ConfigurationStoreVersion: {
                return new ByteArrayVariable(varType);
            }
            case AMRMToken: {
                return new ByteArrayVariable(varType);
            }
            case RMDTSequenceNumber: {
                return new IntVariable(varType);
            }
            case QuotaTicksCounter: {
                return new LongVariable(varType);
            }
            case CacheDirectiveID: {
                return new LongVariable(varType);
            }
            case neededScanCount: {
                return new IntVariable(varType);
            }
            case completedScanCount: {
                return new IntVariable(varType);
            }
            case curScanCount: {
                return new IntVariable(varType);
            }
            case RollingUpgradeInfo: {
                return new ByteArrayVariable(varType);
            }
            case SafeModeInfo: {
                return new ArrayVariable(varType);
            }
            case GenericDouble: {
                return new DoubleVariable(varType);
            }
            case BlockTotal: 
            case BlockThreshold: 
            case BlockReplicationQueueThreshold: {
                return new IntVariable(varType);
            }
            case FenceID: {
                return new LongVariable(varType);
            }
            case RetryCacheCleanerEpoch: {
                return new LongVariable(varType);
            }
        }
        return null;
    }

    public static Variable initVariable(Finder varType, byte[] varData) {
        Variable var = Variable.getVariable(varType);
        if (var != null) {
            var.setValue(varData);
        }
        return var;
    }

    public static enum Finder implements FinderType<Variable>
    {
        BlockID(0),
        INodeID(1),
        QuotaUpdateID(2),
        ReplicationIndex(3),
        StorageInfo(4),
        BlockTokenKeys(5),
        BTCurrKey(6),
        BTNextKey(7),
        BTSimpleKey(8),
        SIdCounter(9),
        HdfsLeParams(10),
        YarnLeParams(11),
        MisReplicatedFilesIndex(12),
        SafeModeReached(13),
        BrLbMaxConcurrentBRs(14),
        RMStateStoreVersion(15),
        RMStateStoreEpoch(16),
        AMRMToken(17),
        RMDTSequenceNumber(18),
        QuotaTicksCounter(19),
        GenericInteger(20),
        GenericLong(21),
        GenericString(22),
        GenericByteArray(23),
        GenericArray(24),
        StorageMap(26),
        CacheDirectiveID(27),
        neededScanCount(28),
        RollingUpgradeInfo(29),
        SafeModeInfo(30),
        GenericDouble(31),
        BlockTotal(32),
        BlockThreshold(33),
        BlockReplicationQueueThreshold(34),
        completedScanCount(35),
        curScanCount(36),
        FenceID(37),
        ConfigurationStoreVersion(38),
        RetryCacheCleanerEpoch(39);

        private final int id;
        private static Map<Integer, Finder> idToFinder;

        private Finder(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public byte[] getDefaultValue() {
            return defaultValues.get(this);
        }

        public static Finder getFinder(int varType) {
            Finder finder;
            if (idToFinder.isEmpty()) {
                Finder[] Finders;
                for (Finder finder2 : Finders = Finder.values()) {
                    idToFinder.put(finder2.getId(), finder2);
                }
            }
            if ((finder = idToFinder.get(varType)) == null) {
                throw new IllegalArgumentException("Variable Type " + varType + " doesn't exist");
            }
            return finder;
        }

        @Override
        public Class getType() {
            return Variable.class;
        }

        @Override
        public FinderType.Annotation getAnnotated() {
            return FinderType.Annotation.PrimaryKey;
        }

        static {
            idToFinder = new HashMap<Integer, Finder>(Finder.values().length);
        }
    }
}

