/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.io.hops.metadata.hdfs.entity;

import io.hops.hadoop.shaded.io.hops.metadata.hdfs.entity.MetadataLogEntry;
import io.hops.hadoop.shaded.io.hops.metadata.hdfs.entity.StoredXAttr;

public final class XAttrMetadataLogEntry
extends MetadataLogEntry {
    private final Operation operation;

    public XAttrMetadataLogEntry(MetadataLogEntry entry) {
        super(entry);
        this.operation = Operation.valueOf(entry.getOperationId());
    }

    public XAttrMetadataLogEntry(long datasetId, long inodeId, int logicalTime, long inodePartitionId, long inodeParentId, String inodeName, byte[] value, byte namespace, String name, Operation operation) {
        super(datasetId, inodeId, logicalTime, inodePartitionId, inodeParentId, inodeName, StoredXAttr.getNumParts(value), namespace, name, operation.getId());
        this.operation = operation;
    }

    public XAttrMetadataLogEntry(long datasetId, long inodeId, int logicalTime, long inodePartitionId, long inodeParentId, String inodeName) {
        super(datasetId, inodeId, logicalTime, inodePartitionId, inodeParentId, inodeName, Operation.AddAll.getId());
        this.operation = Operation.AddAll;
    }

    public short getNumParts() {
        return (short)this.getPk1();
    }

    public byte getNamespace() {
        return (byte)this.getPk2();
    }

    public String getName() {
        return this.getPk3();
    }

    public Operation getOperation() {
        return this.operation;
    }

    public static boolean isValidOperation(short operationId) {
        return Operation.valueOf(operationId) != null;
    }

    public static enum Operation implements MetadataLogEntry.OperationBase
    {
        Add(10),
        AddAll(11),
        Update(12),
        Delete(13);

        private final short opId;

        private Operation(short opId) {
            this.opId = opId;
        }

        @Override
        public short getId() {
            return this.opId;
        }

        static Operation valueOf(short id) {
            for (Operation op : Operation.values()) {
                if (op.getId() != id) continue;
                return op;
            }
            throw new IllegalArgumentException("invalid operatin id " + id);
        }
    }
}

