/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.commons.configuration2.tree.xpath;

import io.hops.hadoop.shaded.org.apache.commons.configuration2.tree.xpath.ConfigurationAttributePointer;
import io.hops.hadoop.shaded.org.apache.commons.configuration2.tree.xpath.ConfigurationNodeIteratorBase;
import io.hops.hadoop.shaded.org.apache.commons.configuration2.tree.xpath.ConfigurationNodePointer;
import io.hops.hadoop.shaded.org.apache.commons.jxpath.ri.QName;
import io.hops.hadoop.shaded.org.apache.commons.jxpath.ri.model.NodePointer;
import io.hops.hadoop.shaded.org.apache.commons.lang3.StringUtils;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

class ConfigurationNodeIteratorAttribute<T>
extends ConfigurationNodeIteratorBase<T> {
    private static final String WILDCARD = "*";
    private ConfigurationNodePointer<T> parentPointer;
    private List<String> attributeNames;

    public ConfigurationNodeIteratorAttribute(ConfigurationNodePointer<T> parent, QName name) {
        super(parent, false);
        this.parentPointer = parent;
        this.attributeNames = this.createAttributeDataList(parent, name);
    }

    @Override
    protected NodePointer createNodePointer(int position) {
        return new ConfigurationAttributePointer<T>(this.parentPointer, this.attributeNames.get(position));
    }

    @Override
    protected int size() {
        return this.attributeNames.size();
    }

    private List<String> createAttributeDataList(ConfigurationNodePointer<T> parent, QName name) {
        ArrayList<String> result = new ArrayList<String>();
        if (!WILDCARD.equals(name.getName())) {
            this.addAttributeData(parent, result, ConfigurationNodeIteratorAttribute.qualifiedName(name));
        } else {
            LinkedHashSet<String> names = new LinkedHashSet<String>(parent.getNodeHandler().getAttributes(parent.getConfigurationNode()));
            String prefix = name.getPrefix() != null ? ConfigurationNodeIteratorAttribute.prefixName(name.getPrefix(), null) : null;
            for (String n : names) {
                if (prefix != null && !StringUtils.startsWith(n, prefix)) continue;
                this.addAttributeData(parent, result, n);
            }
        }
        return result;
    }

    private void addAttributeData(ConfigurationNodePointer<T> parent, List<String> result, String name) {
        if (parent.getNodeHandler().getAttributeValue(parent.getConfigurationNode(), name) != null) {
            result.add(name);
        }
    }
}

