/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.com.logicalclocks.servicediscoverclient.resolvers;

import io.hops.hadoop.shaded.com.logicalclocks.servicediscoverclient.Builder;
import io.hops.hadoop.shaded.com.logicalclocks.servicediscoverclient.ServiceDiscoveryClient;
import io.hops.hadoop.shaded.com.logicalclocks.servicediscoverclient.exceptions.ServiceDiscoveryException;
import io.hops.hadoop.shaded.com.logicalclocks.servicediscoverclient.exceptions.ServiceDiscoveryGenericException;
import io.hops.hadoop.shaded.com.logicalclocks.servicediscoverclient.exceptions.ServiceNotFoundException;
import io.hops.hadoop.shaded.com.logicalclocks.servicediscoverclient.service.Service;
import io.hops.hadoop.shaded.com.logicalclocks.servicediscoverclient.service.ServiceQuery;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.google.common.net.HostAndPort;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul.Consul;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul.ConsulException;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul.HealthClient;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul.model.health.ServiceHealth;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul.option.ImmutableQueryOptions;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul.option.QueryOptions;
import java.util.List;
import java.util.stream.Stream;
import lombok.NonNull;

public class HttpResolver
implements ServiceDiscoveryClient {
    private Consul client;

    @Override
    public void init(@NonNull Builder builder) throws ServiceDiscoveryGenericException {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.client = builder.getClient() != null ? builder.getClient() : this.createConsulClient(builder);
    }

    private Consul createConsulClient(Builder builder) throws ServiceDiscoveryGenericException {
        try {
            HostAndPort hostAndPort = HostAndPort.fromParts(builder.getHttpHost(), builder.getHttpPort());
            return Consul.builder().withHostAndPort(hostAndPort).withHttps(builder.getHttps()).withSslContext(builder.getSslContext()).withHostnameVerifier(builder.getHostnameVerifier()).build();
        }
        catch (ConsulException ex) {
            throw new ServiceDiscoveryGenericException("Could not initialize client", ex);
        }
    }

    @Override
    public Stream<Service> getService(@NonNull ServiceQuery service) throws ServiceDiscoveryException {
        if (service == null) {
            throw new NullPointerException("service is marked non-null but is null");
        }
        ImmutableQueryOptions queryOptions = ImmutableQueryOptions.builder().addAllTag(service.getTags()).build();
        List<ServiceHealth> serviceHealths = this.getServiceHealth(service.getName(), queryOptions);
        if (serviceHealths.isEmpty()) {
            throw new ServiceNotFoundException("Could not find service " + service);
        }
        return serviceHealths.stream().map(this::convertToService);
    }

    private List<ServiceHealth> getServiceHealth(String name, QueryOptions queryOptions) throws ServiceDiscoveryGenericException {
        try {
            HealthClient hc = this.client.healthClient();
            return hc.getHealthyServiceInstances(name, queryOptions).getResponse();
        }
        catch (ConsulException ex) {
            throw new ServiceDiscoveryGenericException(ex);
        }
    }

    private Service convertToService(ServiceHealth serviceHealth) {
        return Service.of(serviceHealth.getService().getService(), serviceHealth.getNode().getAddress(), serviceHealth.getService().getPort());
    }

    @Override
    public void close() {
        if (this.client != null) {
            this.client.destroy();
        }
    }
}

