/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul.cache;

import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.google.common.primitives.Ints;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul.CatalogClient;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul.async.ConsulResponseCallback;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul.cache.CacheDescriptor;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul.cache.ConsulCache;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul.config.CacheConfig;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul.model.health.Node;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul.option.QueryOptions;
import java.math.BigInteger;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;

public class NodesCatalogCache
extends ConsulCache<String, Node> {
    private NodesCatalogCache(CatalogClient catalogClient, QueryOptions queryOptions, int watchSeconds, ConsulCache.Scheduler callbackScheduler) {
        super(Node::getNode, (BigInteger index, ConsulResponseCallback<List<V>> callback) -> catalogClient.getNodes(NodesCatalogCache.watchParams(index, watchSeconds, queryOptions), callback), catalogClient.getConfig().getCacheConfig(), catalogClient.getEventHandler(), new CacheDescriptor("catalog.nodes"), callbackScheduler);
    }

    public static NodesCatalogCache newCache(CatalogClient catalogClient, QueryOptions queryOptions, int watchSeconds, ScheduledExecutorService callbackExecutorService) {
        ConsulCache.Scheduler scheduler = NodesCatalogCache.createExternal(callbackExecutorService);
        return new NodesCatalogCache(catalogClient, queryOptions, watchSeconds, scheduler);
    }

    public static NodesCatalogCache newCache(CatalogClient catalogClient, QueryOptions queryOptions, int watchSeconds) {
        return new NodesCatalogCache(catalogClient, queryOptions, watchSeconds, NodesCatalogCache.createDefault());
    }

    public static NodesCatalogCache newCache(CatalogClient catalogClient) {
        CacheConfig cacheConfig = catalogClient.getConfig().getCacheConfig();
        int watchSeconds = Ints.checkedCast(cacheConfig.getWatchDuration().getSeconds());
        return NodesCatalogCache.newCache(catalogClient, QueryOptions.BLANK, watchSeconds);
    }
}

