/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.com.nimbusds.jose.jwk;

import io.hops.hadoop.shaded.com.nimbusds.jose.jwk.JWK;
import io.hops.hadoop.shaded.com.nimbusds.jose.jwk.JWKMatcher;
import io.hops.hadoop.shaded.com.nimbusds.jose.jwk.JWKSet;
import io.hops.hadoop.shaded.net.jcip.annotations.Immutable;
import java.util.LinkedList;
import java.util.List;

@Immutable
public final class JWKSelector {
    private final JWKMatcher matcher;

    public JWKSelector(JWKMatcher matcher) {
        if (matcher == null) {
            throw new IllegalArgumentException("The JWK matcher must not be null");
        }
        this.matcher = matcher;
    }

    public JWKMatcher getMatcher() {
        return this.matcher;
    }

    public List<JWK> select(JWKSet jwkSet) {
        LinkedList<JWK> selectedKeys = new LinkedList<JWK>();
        if (jwkSet == null) {
            return selectedKeys;
        }
        for (JWK key : jwkSet.getKeys()) {
            if (!this.matcher.matches(key)) continue;
            selectedKeys.add(key);
        }
        return selectedKeys;
    }
}

