/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.io.hops.metadata.hdfs.entity;

import io.hops.hadoop.shaded.io.hops.metadata.hdfs.entity.StoredXAttr;
import java.util.Objects;

public final class FileProvXAttrBufferEntry {
    private final PrimaryKey key;
    private final byte[] value;

    public FileProvXAttrBufferEntry(long iNodeId, byte namespace, String name, int iNodeLogicalTime, byte[] value) {
        this.key = new PrimaryKey(iNodeId, namespace, name, iNodeLogicalTime);
        this.value = value;
    }

    public FileProvXAttrBufferEntry(long inodeId, byte namespace, String name, int inodeLogicalTime, String value) {
        this(inodeId, namespace, name, inodeLogicalTime, StoredXAttr.getXAttrBytes(value));
    }

    public long getInodeId() {
        return this.key.getInodeId();
    }

    public byte getNamespace() {
        return this.key.getNamespace();
    }

    public String getName() {
        return this.key.getName();
    }

    public int getINodeLogicalTime() {
        return this.key.getiNodeLogicalTime();
    }

    public byte[] getValue() {
        return this.value;
    }

    public short getNumParts() {
        return StoredXAttr.getNumParts(this.value);
    }

    public byte[] getValue(short index) {
        return StoredXAttr.getValue(this.value, index);
    }

    public String toString() {
        return "FileProvXAttrBufferEntry{key='" + this.key + '\'' + ", value='" + StoredXAttr.getXAttrString(this.value) + '\'' + '}';
    }

    public static final class PrimaryKey {
        private final long inodeId;
        private final byte namespace;
        private final String name;
        private final int iNodeLogicalTime;

        public PrimaryKey(long inodeId, byte namespace, String name, int iNodeLogicalTime) {
            this.inodeId = inodeId;
            this.namespace = namespace;
            this.name = name;
            this.iNodeLogicalTime = iNodeLogicalTime;
        }

        public long getInodeId() {
            return this.inodeId;
        }

        public byte getNamespace() {
            return this.namespace;
        }

        public String getName() {
            return this.name;
        }

        public int getiNodeLogicalTime() {
            return this.iNodeLogicalTime;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PrimaryKey)) {
                return false;
            }
            PrimaryKey that = (PrimaryKey)o;
            return this.inodeId == that.inodeId && this.namespace == that.namespace && this.name.equals(that.name) && this.iNodeLogicalTime == that.iNodeLogicalTime;
        }

        public int hashCode() {
            return Objects.hash(this.inodeId, this.namespace, this.name, this.iNodeLogicalTime);
        }

        public String toString() {
            return "FileProvXAttrBuffer.PrimaryKey{inodeId=" + this.inodeId + ", namespace=" + this.namespace + ", name='" + this.name + ", iNodeLogicalTime='" + this.iNodeLogicalTime + '\'' + '}';
        }
    }
}

