/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.io.hops.util;

public class IntMerge {
    private static final int SPLIT = 32;
    private static long partKeyBitMask = -4294967296L;
    private static long idBitMask = 0xFFFFFFFFL;

    public static int getUpperNumber(long number) {
        long upperPart = partKeyBitMask & number;
        if ((upperPart >>= 32) < 0L) {
            throw new ArithmeticException("Can not handle negative numbers");
        }
        if (upperPart > Integer.MAX_VALUE) {
            throw new ArithmeticException("Number is greater than 2147483647");
        }
        return (int)upperPart;
    }

    public static long getLowerNumber(long number) {
        long lowerPart = idBitMask & number;
        if (lowerPart < 0L) {
            throw new ArithmeticException("Can not handle negative numbers");
        }
        return lowerPart;
    }

    public static long combineTwoNumbers(long upperPart, long lowerPart) {
        if (upperPart < 0L || lowerPart < 0L) {
            throw new ArithmeticException("Can not handle negative numbers. Upper part " + upperPart + " LowerPart " + lowerPart);
        }
        long upperTemp = upperPart;
        if ((upperTemp <<= 32) < 0L) {
            throw new ArithmeticException("Upper part number is too big. overflow");
        }
        long bitMask = -1L;
        long lowerTemp = (bitMask >>>= 32) & lowerPart;
        if (lowerTemp != lowerPart) {
            throw new ArithmeticException("Lower part number is too big. overflow");
        }
        long completeNumber = upperTemp | lowerPart;
        return completeNumber;
    }

    public static void main(String[] argv) {
        long combined = IntMerge.combineTwoNumbers(Integer.MAX_VALUE, Integer.MAX_VALUE);
        combined = IntMerge.combineTwoNumbers(0L, 0L);
        System.out.println("combined " + combined + " upper: " + IntMerge.getUpperNumber(combined) + " lower " + IntMerge.getLowerNumber(combined));
    }
}

