/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul.model.agent;

import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.google.common.base.MoreObjects;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.google.common.collect.ImmutableMap;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul.model.agent.Member;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.org.immutables.value.Generated;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="Member", generator="Immutables")
@Immutable
public final class ImmutableMember
extends Member {
    private final String name;
    private final String address;
    private final int port;
    private final ImmutableMap<String, String> tags;
    private final int status;
    private final int protocolMin;
    private final int protocolMax;
    private final int protocolCur;
    private final int delegateMin;
    private final int delegateMax;
    private final int delegateCur;

    private ImmutableMember(String name, String address, int port, ImmutableMap<String, String> tags, int status, int protocolMin, int protocolMax, int protocolCur, int delegateMin, int delegateMax, int delegateCur) {
        this.name = name;
        this.address = address;
        this.port = port;
        this.tags = tags;
        this.status = status;
        this.protocolMin = protocolMin;
        this.protocolMax = protocolMax;
        this.protocolCur = protocolCur;
        this.delegateMin = delegateMin;
        this.delegateMax = delegateMax;
        this.delegateCur = delegateCur;
    }

    @Override
    @JsonProperty(value="Name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="Addr")
    public String getAddress() {
        return this.address;
    }

    @Override
    @JsonProperty(value="Port")
    public int getPort() {
        return this.port;
    }

    @JsonProperty(value="Tags")
    @JsonDeserialize(as=ImmutableMap.class, keyAs=String.class, contentAs=String.class)
    public ImmutableMap<String, String> getTags() {
        return this.tags;
    }

    @Override
    @JsonProperty(value="Status")
    public int getStatus() {
        return this.status;
    }

    @Override
    @JsonProperty(value="ProtocolMin")
    public int getProtocolMin() {
        return this.protocolMin;
    }

    @Override
    @JsonProperty(value="ProtocolMax")
    public int getProtocolMax() {
        return this.protocolMax;
    }

    @Override
    @JsonProperty(value="ProtocolCur")
    public int getProtocolCur() {
        return this.protocolCur;
    }

    @Override
    @JsonProperty(value="DelegateMin")
    public int getDelegateMin() {
        return this.delegateMin;
    }

    @Override
    @JsonProperty(value="DelegateMax")
    public int getDelegateMax() {
        return this.delegateMax;
    }

    @Override
    @JsonProperty(value="DelegateCur")
    public int getDelegateCur() {
        return this.delegateCur;
    }

    public final ImmutableMember withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableMember(newValue, this.address, this.port, this.tags, this.status, this.protocolMin, this.protocolMax, this.protocolCur, this.delegateMin, this.delegateMax, this.delegateCur);
    }

    public final ImmutableMember withAddress(String value) {
        String newValue = Objects.requireNonNull(value, "address");
        if (this.address.equals(newValue)) {
            return this;
        }
        return new ImmutableMember(this.name, newValue, this.port, this.tags, this.status, this.protocolMin, this.protocolMax, this.protocolCur, this.delegateMin, this.delegateMax, this.delegateCur);
    }

    public final ImmutableMember withPort(int value) {
        if (this.port == value) {
            return this;
        }
        return new ImmutableMember(this.name, this.address, value, this.tags, this.status, this.protocolMin, this.protocolMax, this.protocolCur, this.delegateMin, this.delegateMax, this.delegateCur);
    }

    public final ImmutableMember withTags(Map<String, ? extends String> entries) {
        if (this.tags == entries) {
            return this;
        }
        ImmutableMap<String, String> newValue = ImmutableMap.copyOf(entries);
        return new ImmutableMember(this.name, this.address, this.port, newValue, this.status, this.protocolMin, this.protocolMax, this.protocolCur, this.delegateMin, this.delegateMax, this.delegateCur);
    }

    public final ImmutableMember withStatus(int value) {
        if (this.status == value) {
            return this;
        }
        return new ImmutableMember(this.name, this.address, this.port, this.tags, value, this.protocolMin, this.protocolMax, this.protocolCur, this.delegateMin, this.delegateMax, this.delegateCur);
    }

    public final ImmutableMember withProtocolMin(int value) {
        if (this.protocolMin == value) {
            return this;
        }
        return new ImmutableMember(this.name, this.address, this.port, this.tags, this.status, value, this.protocolMax, this.protocolCur, this.delegateMin, this.delegateMax, this.delegateCur);
    }

    public final ImmutableMember withProtocolMax(int value) {
        if (this.protocolMax == value) {
            return this;
        }
        return new ImmutableMember(this.name, this.address, this.port, this.tags, this.status, this.protocolMin, value, this.protocolCur, this.delegateMin, this.delegateMax, this.delegateCur);
    }

    public final ImmutableMember withProtocolCur(int value) {
        if (this.protocolCur == value) {
            return this;
        }
        return new ImmutableMember(this.name, this.address, this.port, this.tags, this.status, this.protocolMin, this.protocolMax, value, this.delegateMin, this.delegateMax, this.delegateCur);
    }

    public final ImmutableMember withDelegateMin(int value) {
        if (this.delegateMin == value) {
            return this;
        }
        return new ImmutableMember(this.name, this.address, this.port, this.tags, this.status, this.protocolMin, this.protocolMax, this.protocolCur, value, this.delegateMax, this.delegateCur);
    }

    public final ImmutableMember withDelegateMax(int value) {
        if (this.delegateMax == value) {
            return this;
        }
        return new ImmutableMember(this.name, this.address, this.port, this.tags, this.status, this.protocolMin, this.protocolMax, this.protocolCur, this.delegateMin, value, this.delegateCur);
    }

    public final ImmutableMember withDelegateCur(int value) {
        if (this.delegateCur == value) {
            return this;
        }
        return new ImmutableMember(this.name, this.address, this.port, this.tags, this.status, this.protocolMin, this.protocolMax, this.protocolCur, this.delegateMin, this.delegateMax, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMember && this.equalTo((ImmutableMember)another);
    }

    private boolean equalTo(ImmutableMember another) {
        return this.name.equals(another.name) && this.address.equals(another.address) && this.port == another.port && this.tags.equals(another.tags) && this.status == another.status && this.protocolMin == another.protocolMin && this.protocolMax == another.protocolMax && this.protocolCur == another.protocolCur && this.delegateMin == another.delegateMin && this.delegateMax == another.delegateMax && this.delegateCur == another.delegateCur;
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.name.hashCode();
        h2 += (h2 << 5) + this.address.hashCode();
        h2 += (h2 << 5) + this.port;
        h2 += (h2 << 5) + this.tags.hashCode();
        h2 += (h2 << 5) + this.status;
        h2 += (h2 << 5) + this.protocolMin;
        h2 += (h2 << 5) + this.protocolMax;
        h2 += (h2 << 5) + this.protocolCur;
        h2 += (h2 << 5) + this.delegateMin;
        h2 += (h2 << 5) + this.delegateMax;
        h2 += (h2 << 5) + this.delegateCur;
        return h2;
    }

    public String toString() {
        return MoreObjects.toStringHelper("Member").omitNullValues().add("name", this.name).add("address", this.address).add("port", this.port).add("tags", this.tags).add("status", this.status).add("protocolMin", this.protocolMin).add("protocolMax", this.protocolMax).add("protocolCur", this.protocolCur).add("delegateMin", this.delegateMin).add("delegateMax", this.delegateMax).add("delegateCur", this.delegateCur).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableMember fromJson(Json json) {
        Builder builder = ImmutableMember.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.address != null) {
            builder.address(json.address);
        }
        if (json.portIsSet) {
            builder.port(json.port);
        }
        if (json.tags != null) {
            builder.putAllTags(json.tags);
        }
        if (json.statusIsSet) {
            builder.status(json.status);
        }
        if (json.protocolMinIsSet) {
            builder.protocolMin(json.protocolMin);
        }
        if (json.protocolMaxIsSet) {
            builder.protocolMax(json.protocolMax);
        }
        if (json.protocolCurIsSet) {
            builder.protocolCur(json.protocolCur);
        }
        if (json.delegateMinIsSet) {
            builder.delegateMin(json.delegateMin);
        }
        if (json.delegateMaxIsSet) {
            builder.delegateMax(json.delegateMax);
        }
        if (json.delegateCurIsSet) {
            builder.delegateCur(json.delegateCur);
        }
        return builder.build();
    }

    public static ImmutableMember copyOf(Member instance) {
        if (instance instanceof ImmutableMember) {
            return (ImmutableMember)instance;
        }
        return ImmutableMember.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Member", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_ADDRESS = 2L;
        private static final long INIT_BIT_PORT = 4L;
        private static final long INIT_BIT_STATUS = 8L;
        private static final long INIT_BIT_PROTOCOL_MIN = 16L;
        private static final long INIT_BIT_PROTOCOL_MAX = 32L;
        private static final long INIT_BIT_PROTOCOL_CUR = 64L;
        private static final long INIT_BIT_DELEGATE_MIN = 128L;
        private static final long INIT_BIT_DELEGATE_MAX = 256L;
        private static final long INIT_BIT_DELEGATE_CUR = 512L;
        private long initBits = 1023L;
        @Nullable
        private String name;
        @Nullable
        private String address;
        private int port;
        private ImmutableMap.Builder<String, String> tags = ImmutableMap.builder();
        private int status;
        private int protocolMin;
        private int protocolMax;
        private int protocolCur;
        private int delegateMin;
        private int delegateMax;
        private int delegateCur;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Member instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.getName());
            this.address(instance.getAddress());
            this.port(instance.getPort());
            this.putAllTags(instance.getTags());
            this.status(instance.getStatus());
            this.protocolMin(instance.getProtocolMin());
            this.protocolMax(instance.getProtocolMax());
            this.protocolCur(instance.getProtocolCur());
            this.delegateMin(instance.getDelegateMin());
            this.delegateMax(instance.getDelegateMax());
            this.delegateCur(instance.getDelegateCur());
            return this;
        }

        @JsonProperty(value="Name")
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="Addr")
        @CanIgnoreReturnValue
        public final Builder address(String address) {
            this.address = Objects.requireNonNull(address, "address");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="Port")
        @CanIgnoreReturnValue
        public final Builder port(int port) {
            this.port = port;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putTags(String key, String value) {
            this.tags.put(key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putTags(Map.Entry<String, ? extends String> entry) {
            this.tags.put(entry);
            return this;
        }

        @JsonProperty(value="Tags")
        @JsonDeserialize(as=ImmutableMap.class, keyAs=String.class, contentAs=String.class)
        @CanIgnoreReturnValue
        public final Builder tags(Map<String, ? extends String> entries) {
            this.tags = ImmutableMap.builder();
            return this.putAllTags(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllTags(Map<String, ? extends String> entries) {
            this.tags.putAll(entries);
            return this;
        }

        @JsonProperty(value="Status")
        @CanIgnoreReturnValue
        public final Builder status(int status) {
            this.status = status;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="ProtocolMin")
        @CanIgnoreReturnValue
        public final Builder protocolMin(int protocolMin) {
            this.protocolMin = protocolMin;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="ProtocolMax")
        @CanIgnoreReturnValue
        public final Builder protocolMax(int protocolMax) {
            this.protocolMax = protocolMax;
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @JsonProperty(value="ProtocolCur")
        @CanIgnoreReturnValue
        public final Builder protocolCur(int protocolCur) {
            this.protocolCur = protocolCur;
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @JsonProperty(value="DelegateMin")
        @CanIgnoreReturnValue
        public final Builder delegateMin(int delegateMin) {
            this.delegateMin = delegateMin;
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        @JsonProperty(value="DelegateMax")
        @CanIgnoreReturnValue
        public final Builder delegateMax(int delegateMax) {
            this.delegateMax = delegateMax;
            this.initBits &= 0xFFFFFFFFFFFFFEFFL;
            return this;
        }

        @JsonProperty(value="DelegateCur")
        @CanIgnoreReturnValue
        public final Builder delegateCur(int delegateCur) {
            this.delegateCur = delegateCur;
            this.initBits &= 0xFFFFFFFFFFFFFDFFL;
            return this;
        }

        public ImmutableMember build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMember(this.name, this.address, this.port, this.tags.build(), this.status, this.protocolMin, this.protocolMax, this.protocolCur, this.delegateMin, this.delegateMax, this.delegateCur);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("address");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("port");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("status");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("protocolMin");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("protocolMax");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("protocolCur");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("delegateMin");
            }
            if ((this.initBits & 0x100L) != 0L) {
                attributes.add("delegateMax");
            }
            if ((this.initBits & 0x200L) != 0L) {
                attributes.add("delegateCur");
            }
            return "Cannot build Member, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Member", generator="Immutables")
    static final class Json
    extends Member {
        @Nullable
        String name;
        @Nullable
        String address;
        int port;
        boolean portIsSet;
        @Nullable
        Map<String, String> tags = ImmutableMap.of();
        int status;
        boolean statusIsSet;
        int protocolMin;
        boolean protocolMinIsSet;
        int protocolMax;
        boolean protocolMaxIsSet;
        int protocolCur;
        boolean protocolCurIsSet;
        int delegateMin;
        boolean delegateMinIsSet;
        int delegateMax;
        boolean delegateMaxIsSet;
        int delegateCur;
        boolean delegateCurIsSet;

        Json() {
        }

        @JsonProperty(value="Name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="Addr")
        public void setAddress(String address) {
            this.address = address;
        }

        @JsonProperty(value="Port")
        public void setPort(int port) {
            this.port = port;
            this.portIsSet = true;
        }

        @JsonProperty(value="Tags")
        @JsonDeserialize(as=ImmutableMap.class, keyAs=String.class, contentAs=String.class)
        public void setTags(Map<String, String> tags) {
            this.tags = tags;
        }

        @JsonProperty(value="Status")
        public void setStatus(int status) {
            this.status = status;
            this.statusIsSet = true;
        }

        @JsonProperty(value="ProtocolMin")
        public void setProtocolMin(int protocolMin) {
            this.protocolMin = protocolMin;
            this.protocolMinIsSet = true;
        }

        @JsonProperty(value="ProtocolMax")
        public void setProtocolMax(int protocolMax) {
            this.protocolMax = protocolMax;
            this.protocolMaxIsSet = true;
        }

        @JsonProperty(value="ProtocolCur")
        public void setProtocolCur(int protocolCur) {
            this.protocolCur = protocolCur;
            this.protocolCurIsSet = true;
        }

        @JsonProperty(value="DelegateMin")
        public void setDelegateMin(int delegateMin) {
            this.delegateMin = delegateMin;
            this.delegateMinIsSet = true;
        }

        @JsonProperty(value="DelegateMax")
        public void setDelegateMax(int delegateMax) {
            this.delegateMax = delegateMax;
            this.delegateMaxIsSet = true;
        }

        @JsonProperty(value="DelegateCur")
        public void setDelegateCur(int delegateCur) {
            this.delegateCur = delegateCur;
            this.delegateCurIsSet = true;
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getAddress() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getPort() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, String> getTags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getStatus() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getProtocolMin() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getProtocolMax() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getProtocolCur() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getDelegateMin() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getDelegateMax() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getDelegateCur() {
            throw new UnsupportedOperationException();
        }
    }
}

