/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;

final class FormattedTime {
    private static final DateTimeFormatter DEFAULT_FORMAT = DateTimeFormatter.ofPattern("yyyyMMddHHmmss").withZone(ZoneOffset.UTC);

    private FormattedTime() {
    }

    public static String format(Instant date) {
        return DEFAULT_FORMAT.format(date);
    }

    public static Instant parse(String s2) throws DateTimeParseException {
        if (s2.length() == 14) {
            return DEFAULT_FORMAT.parse((CharSequence)s2, Instant::from);
        }
        if (s2.length() <= 10) {
            return Instant.ofEpochSecond(Long.parseLong(s2));
        }
        throw new DateTimeParseException("Invalid time encoding: ", s2, 0);
    }
}

