/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS;

import io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS.Compression;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS.DNSInput;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS.DNSOutput;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS.Name;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS.Record;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS.Tokenizer;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS.Type;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.org.xbill.DNS.TypeBitmap;
import java.io.IOException;

public class NSECRecord
extends Record {
    private Name next;
    private TypeBitmap types;

    NSECRecord() {
    }

    public NSECRecord(Name name, int dclass, long ttl, Name next, int[] types) {
        super(name, 47, dclass, ttl);
        this.next = NSECRecord.checkName("next", next);
        for (int value : types) {
            Type.check(value);
        }
        this.types = new TypeBitmap(types);
    }

    @Override
    void rrFromWire(DNSInput in) throws IOException {
        this.next = new Name(in);
        this.types = new TypeBitmap(in);
    }

    @Override
    void rrToWire(DNSOutput out, Compression c, boolean canonical) {
        this.next.toWire(out, null, false);
        this.types.toWire(out);
    }

    @Override
    void rdataFromString(Tokenizer st, Name origin) throws IOException {
        this.next = st.getName(origin);
        this.types = new TypeBitmap(st);
    }

    @Override
    String rrToString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.next);
        if (!this.types.empty()) {
            sb.append(' ');
            sb.append(this.types.toString());
        }
        return sb.toString();
    }

    public Name getNext() {
        return this.next;
    }

    public int[] getTypes() {
        return this.types.toArray();
    }

    public boolean hasType(int type) {
        return this.types.contains(type);
    }
}

