/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.com.nimbusds.jwt;

import io.hops.hadoop.shaded.com.nimbusds.jose.JOSEObject;
import io.hops.hadoop.shaded.com.nimbusds.jose.JWSHeader;
import io.hops.hadoop.shaded.com.nimbusds.jose.JWSObject;
import io.hops.hadoop.shaded.com.nimbusds.jose.Payload;
import io.hops.hadoop.shaded.com.nimbusds.jose.util.Base64URL;
import io.hops.hadoop.shaded.com.nimbusds.jwt.JWT;
import io.hops.hadoop.shaded.com.nimbusds.jwt.JWTClaimsSet;
import io.hops.hadoop.shaded.net.jcip.annotations.ThreadSafe;
import io.hops.hadoop.shaded.net.minidev.json.JSONObject;
import java.text.ParseException;

@ThreadSafe
public class SignedJWT
extends JWSObject
implements JWT {
    private static final long serialVersionUID = 1L;

    public SignedJWT(JWSHeader header, JWTClaimsSet claimsSet) {
        super(header, new Payload(claimsSet.toJSONObject()));
    }

    public SignedJWT(Base64URL firstPart, Base64URL secondPart, Base64URL thirdPart) throws ParseException {
        super(firstPart, secondPart, thirdPart);
    }

    @Override
    public JWTClaimsSet getJWTClaimsSet() throws ParseException {
        JSONObject json = this.getPayload().toJSONObject();
        if (json == null) {
            throw new ParseException("Payload of JWS object is not a valid JSON object", 0);
        }
        return JWTClaimsSet.parse(json);
    }

    public static SignedJWT parse(String s2) throws ParseException {
        Base64URL[] parts = JOSEObject.split(s2);
        if (parts.length != 3) {
            throw new ParseException("Unexpected number of Base64URL parts, must be three", 0);
        }
        return new SignedJWT(parts[0], parts[1], parts[2]);
    }
}

